/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

class BLDComponent
extends JComponent {
    private Color normalHue;
    private final Dimension preferredSize;
    private String name;
    private boolean restrictMaximumSize;
    private boolean printSize;

    public BLDComponent(float f, float f2, int n, boolean bl, boolean bl2, String string) {
        this.name = string;
        this.restrictMaximumSize = bl;
        this.printSize = bl2;
        this.setAlignmentX(f);
        this.normalHue = Color.getHSBColor(f2, 0.4f, 0.85f);
        this.preferredSize = new Dimension(n * 2, n);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n = BLDComponent.this.getWidth();
                float f = (float)mouseEvent.getX() / (float)n;
                int n2 = Math.round(f * 10.0f);
                f = (float)n2 / 10.0f;
                BLDComponent.this.setAlignmentX(f);
                BLDComponent.this.revalidate();
                BLDComponent.this.repaint();
            }
        };
        this.addMouseListener(mouseAdapter);
    }

    public Dimension getMaximumSize() {
        if (this.restrictMaximumSize) {
            return this.preferredSize;
        }
        return super.getMaximumSize();
    }

    public Dimension getMinimumSize() {
        return this.preferredSize;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public boolean isOpaque() {
        return true;
    }

    public void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        float f = this.getAlignmentX();
        graphics.setColor(this.normalHue);
        graphics.fill3DRect(0, 0, n, n2, true);
        graphics.setColor(Color.white);
        int n3 = (int)(f * (float)n) - 1;
        graphics.drawLine(n3, 0, n3, n2 - 1);
        graphics.setColor(Color.black);
        graphics.drawString(Float.toString(f), 3, n2 - 3);
        if (this.printSize) {
            System.out.println("BLDComponent " + this.name + ": size is " + n + "x" + n2 + "; preferred size is " + this.getPreferredSize().width + "x" + this.getPreferredSize().height);
        }
    }

    public void setSizeRestriction(boolean bl) {
        this.restrictMaximumSize = bl;
    }
}

