/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BoxLayoutDemo {
    protected static int NUM_COMPONENTS = 3;
    protected static float[] xAlignment;
    protected static float[] hue;
    protected static boolean restrictSize;
    protected static boolean sizeIsRandom;
    protected static BLDComponent[] bldComponent;

    static {
        float[] fArray = new float[3];
        fArray[1] = 0.5f;
        fArray[2] = 1.0f;
        xAlignment = fArray;
        float[] fArray2 = new float[3];
        fArray2[1] = 0.33f;
        fArray2[2] = 0.67f;
        hue = fArray2;
        restrictSize = true;
        sizeIsRandom = false;
        bldComponent = new BLDComponent[NUM_COMPONENTS];
    }

    public static void main(String[] stringArray) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        int n = 15;
        int n2 = 0;
        while (n2 < NUM_COMPONENTS) {
            n = sizeIsRandom ? (int)(30.0 * Math.random()) + 30 : (n += 10);
            BoxLayoutDemo.bldComponent[n2] = new BLDComponent(xAlignment[n2], hue[n2], n, restrictSize, sizeIsRandom, String.valueOf(n2));
            jPanel.add(bldComponent[n2]);
            ++n2;
        }
        JLabel jLabel = new JLabel("Click a rectangle to change its X alignment.");
        JCheckBox jCheckBox = new JCheckBox("Restrict maximum rectangle size.");
        jCheckBox.setSelected(restrictSize);
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                restrictSize = itemEvent.getStateChange() == 1;
                BoxLayoutDemo.notifyBLDComponents();
            }
        });
        JFrame jFrame = new JFrame("BoxLayoutDemo");
        Container container = jFrame.getContentPane();
        container.add((Component)jPanel, "Center");
        jPanel.setBorder(BorderFactory.createLineBorder(Color.red));
        Box box = Box.createVerticalBox();
        box.add(jLabel);
        box.add(jCheckBox);
        container.add((Component)box, "South");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.pack();
        ((Component)jFrame).setVisible(true);
    }

    public static void notifyBLDComponents() {
        int n = 0;
        while (n < NUM_COMPONENTS) {
            bldComponent[n].setSizeRestriction(restrictSize);
            ++n;
        }
        bldComponent[0].revalidate();
    }
}

