/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class DiagonalLayout
implements LayoutManager {
    private int vgap;
    private int minWidth = 0;
    private int minHeight = 0;
    private int preferredWidth = 0;
    private int preferredHeight = 0;
    private boolean sizeUnknown = true;

    public DiagonalLayout() {
        this(5);
    }

    public DiagonalLayout(int n) {
        this.vgap = n;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getSize().width - (insets.left + insets.right);
        int n2 = container.getSize().height - (insets.top + insets.bottom);
        int n3 = container.getComponentCount();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = insets.top;
        boolean bl = false;
        boolean bl2 = false;
        int n8 = 0;
        int n9 = 0;
        boolean bl3 = false;
        if (this.sizeUnknown) {
            this.setSizes(container);
        }
        if (n <= this.minWidth) {
            bl3 = true;
        }
        if (n != this.preferredWidth) {
            n8 = (n - this.preferredWidth) / (n3 - 1);
        }
        if (n2 > this.preferredHeight) {
            n9 = (n2 - this.preferredHeight) / (n3 - 1);
        }
        int n10 = 0;
        while (n10 < n3) {
            Component component = container.getComponent(n10);
            if (component.isVisible()) {
                Dimension dimension = component.getPreferredSize();
                if (n10 > 0) {
                    if (!bl3) {
                        n6 += n4 / 2 + n8;
                    }
                    n7 += n5 + this.vgap + n9;
                }
                if (!bl3 && n6 + dimension.width > container.getSize().width - insets.right) {
                    n6 = container.getSize().width - insets.bottom - dimension.width;
                }
                int cfr_ignored_0 = dimension.height;
                int cfr_ignored_1 = container.getSize().height;
                int cfr_ignored_2 = insets.bottom;
                component.setBounds(n6, n7, dimension.width, dimension.height);
                n4 = dimension.width;
                n5 = dimension.height;
            }
            ++n10;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        int n = container.getComponentCount();
        Insets insets = container.getInsets();
        dimension.width = this.minWidth + insets.left + insets.right;
        dimension.height = this.minHeight + insets.top + insets.bottom;
        this.sizeUnknown = false;
        return dimension;
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        int n = container.getComponentCount();
        this.setSizes(container);
        Insets insets = container.getInsets();
        dimension.width = this.preferredWidth + insets.left + insets.right;
        dimension.height = this.preferredHeight + insets.top + insets.bottom;
        this.sizeUnknown = false;
        return dimension;
    }

    public void removeLayoutComponent(Component component) {
    }

    private void setSizes(Container container) {
        int n = container.getComponentCount();
        Dimension dimension = null;
        this.preferredWidth = 0;
        this.preferredHeight = 0;
        this.minWidth = 0;
        this.minHeight = 0;
        int n2 = 0;
        while (n2 < n) {
            Component component = container.getComponent(n2);
            if (component.isVisible()) {
                dimension = component.getPreferredSize();
                if (n2 > 0) {
                    this.preferredWidth += dimension.width / 2;
                    this.preferredHeight += this.vgap;
                } else {
                    this.preferredWidth = dimension.width;
                }
                this.preferredHeight += dimension.height;
                this.minWidth = Math.max(component.getMinimumSize().width, this.minWidth);
                this.minHeight = this.preferredHeight;
            }
            ++n2;
        }
    }

    public String toString() {
        String string = "";
        return String.valueOf(this.getClass().getName()) + "[vgap=" + this.vgap + string + "]";
    }
}

