/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.Hashtable;

public class GraphPaperLayout
implements LayoutManager2 {
    int hgap;
    int vgap;
    Dimension gridSize;
    Hashtable compTable;

    public GraphPaperLayout() {
        this(new Dimension(1, 1));
    }

    public GraphPaperLayout(Dimension dimension) {
        this(dimension, 0, 0);
    }

    public GraphPaperLayout(Dimension dimension, int n, int n2) {
        if (dimension.width <= 0 || dimension.height <= 0) {
            throw new IllegalArgumentException("dimensions must be greater than zero");
        }
        this.gridSize = new Dimension(dimension);
        this.hgap = n;
        this.vgap = n2;
        this.compTable = new Hashtable();
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)object;
            if (rectangle.width <= 0 || rectangle.height <= 0) {
                throw new IllegalArgumentException("cannot add to layout: rectangle must have positive width and height");
            }
            if (rectangle.x < 0 || rectangle.y < 0) {
                throw new IllegalArgumentException("cannot add to layout: rectangle x and y must be >= 0");
            }
            this.setConstraints(component, rectangle);
        } else if (object != null) {
            throw new IllegalArgumentException("cannot add to layout: constraint must be a Rectangle");
        }
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public Dimension getGridSize() {
        return new Dimension(this.gridSize);
    }

    protected Dimension getLargestCellSize(Container container, boolean bl) {
        int n = container.getComponentCount();
        Dimension dimension = new Dimension(0, 0);
        int n2 = 0;
        while (n2 < n) {
            Component component = container.getComponent(n2);
            Rectangle rectangle = (Rectangle)this.compTable.get(component);
            if (component != null && rectangle != null) {
                Dimension dimension2 = bl ? component.getPreferredSize() : component.getMinimumSize();
                dimension.width = Math.max(dimension.width, dimension2.width / rectangle.width);
                dimension.height = Math.max(dimension.height, dimension2.height / rectangle.height);
            }
            ++n2;
        }
        return dimension;
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    protected Dimension getLayoutSize(Container container, boolean bl) {
        Dimension dimension = this.getLargestCellSize(container, bl);
        Insets insets = container.getInsets();
        dimension.width = dimension.width * this.gridSize.width + this.hgap * (this.gridSize.width + 1) + insets.left + insets.right;
        dimension.height = dimension.height * this.gridSize.height + this.vgap * (this.gridSize.height + 1) + insets.top + insets.bottom;
        return dimension;
    }

    public void invalidateLayout(Container container) {
    }

    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n = container.getComponentCount();
            if (n == 0) {
                Object var3_5 = null;
                return;
            }
            Dimension dimension = container.getSize();
            int n2 = dimension.width - (insets.left + insets.right);
            int n3 = dimension.height - (insets.top + insets.bottom);
            int n4 = n2 / this.gridSize.width;
            int n5 = n3 / this.gridSize.height;
            int n6 = (n2 - (this.gridSize.width + 1) * this.hgap) / this.gridSize.width;
            int n7 = (n3 - (this.gridSize.height + 1) * this.vgap) / this.gridSize.height;
            int n8 = 0;
            while (n8 < n) {
                Component component = container.getComponent(n8);
                Rectangle rectangle = (Rectangle)this.compTable.get(component);
                if (rectangle != null) {
                    int n9 = insets.left + n4 * rectangle.x + this.hgap;
                    int n10 = insets.top + n5 * rectangle.y + this.vgap;
                    int n11 = n6 * rectangle.width - this.hgap;
                    int n12 = n7 * rectangle.height - this.vgap;
                    component.setBounds(n9, n10, n11, n12);
                }
                ++n8;
            }
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getLayoutSize(container, false);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getLayoutSize(container, true);
    }

    public void removeLayoutComponent(Component component) {
        this.compTable.remove(component);
    }

    public void setConstraints(Component component, Rectangle rectangle) {
        this.compTable.put(component, new Rectangle(rectangle));
    }

    public void setGridSize(int n, int n2) {
        this.gridSize = new Dimension(n, n2);
    }

    public void setGridSize(Dimension dimension) {
        this.setGridSize(dimension.width, dimension.height);
    }
}

