/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class SelectionDemo {
    JLabel label;
    static String starFile = "images/starfield.gif";
    static /* synthetic */ Class class$SelectionDemo;

    private void buildUI(Container container, ImageIcon imageIcon) {
        container.setLayout(new BoxLayout(container, 3));
        SelectionArea selectionArea = new SelectionArea(imageIcon, this);
        container.add(selectionArea);
        this.label = new JLabel("Drag within the image.");
        this.label.setLabelFor(selectionArea);
        container.add(this.label);
        selectionArea.setAlignmentX(0.0f);
        this.label.setAlignmentX(0.0f);
    }

    public void updateLabel(Rectangle rectangle) {
        int n = rectangle.width;
        int n2 = rectangle.height;
        if (n == 0) {
            n = 1;
        }
        if (n2 == 0) {
            n2 = 1;
        }
        this.label.setText("Rectangle goes from (" + rectangle.x + ", " + rectangle.y + ") to (" + (rectangle.x + n - 1) + ", " + (rectangle.y + n2 - 1) + ").");
    }

    protected static ImageIcon createImageIcon(String string) {
        URL uRL = (class$SelectionDemo == null ? (class$SelectionDemo = SelectionDemo.class$("SelectionDemo")) : class$SelectionDemo).getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("SelectionDemo");
        jFrame.setDefaultCloseOperation(3);
        SelectionDemo selectionDemo = new SelectionDemo();
        selectionDemo.buildUI(jFrame.getContentPane(), SelectionDemo.createImageIcon(starFile));
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SelectionDemo.createAndShowGUI();
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SelectionArea
    extends JLabel {
        Rectangle currentRect = null;
        Rectangle rectToDraw = null;
        Rectangle previousRectDrawn = new Rectangle();
        SelectionDemo controller;

        public SelectionArea(ImageIcon imageIcon, SelectionDemo selectionDemo2) {
            super(imageIcon);
            this.controller = selectionDemo2;
            this.setOpaque(true);
            this.setMinimumSize(new Dimension(10, 10));
            MyListener myListener = new MyListener();
            this.addMouseListener(myListener);
            this.addMouseMotionListener(myListener);
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.currentRect != null) {
                graphics.setXORMode(Color.white);
                graphics.drawRect(this.rectToDraw.x, this.rectToDraw.y, this.rectToDraw.width - 1, this.rectToDraw.height - 1);
                this.controller.updateLabel(this.rectToDraw);
            }
        }

        private void updateDrawableRect(int n, int n2) {
            int n3 = this.currentRect.x;
            int n4 = this.currentRect.y;
            int n5 = this.currentRect.width;
            int n6 = this.currentRect.height;
            if (n5 < 0 && (n3 = n3 - (n5 = 0 - n5) + 1) < 0) {
                n5 += n3;
                n3 = 0;
            }
            if (n6 < 0 && (n4 = n4 - (n6 = 0 - n6) + 1) < 0) {
                n6 += n4;
                n4 = 0;
            }
            if (n3 + n5 > n) {
                n5 = n - n3;
            }
            if (n4 + n6 > n2) {
                n6 = n2 - n4;
            }
            if (this.rectToDraw != null) {
                this.previousRectDrawn.setBounds(this.rectToDraw.x, this.rectToDraw.y, this.rectToDraw.width, this.rectToDraw.height);
                this.rectToDraw.setBounds(n3, n4, n5, n6);
            } else {
                this.rectToDraw = new Rectangle(n3, n4, n5, n6);
            }
        }

        private class MyListener
        extends MouseInputAdapter {
            private MyListener() {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                SelectionArea.this.currentRect = new Rectangle(n, n2, 0, 0);
                SelectionArea.this.updateDrawableRect(SelectionArea.this.getWidth(), SelectionArea.this.getHeight());
                SelectionArea.this.repaint();
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                this.updateSize(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.updateSize(mouseEvent);
            }

            void updateSize(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                SelectionArea.this.currentRect.setSize(n - SelectionArea.this.currentRect.x, n2 - SelectionArea.this.currentRect.y);
                SelectionArea.this.updateDrawableRect(SelectionArea.this.getWidth(), SelectionArea.this.getHeight());
                Rectangle rectangle = SelectionArea.this.rectToDraw.union(SelectionArea.this.previousRectDrawn);
                SelectionArea.this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }
}

