/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class KeyEventDemo
extends JPanel
implements KeyListener,
ActionListener {
    JTextArea displayArea;
    JTextField typingArea;
    static final String newline = "\n";

    public KeyEventDemo() {
        super(new BorderLayout());
        JButton jButton = new JButton("Clear");
        jButton.addActionListener(this);
        this.typingArea = new JTextField(20);
        this.typingArea.addKeyListener(this);
        this.displayArea = new JTextArea();
        this.displayArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.displayArea);
        jScrollPane.setPreferredSize(new Dimension(375, 125));
        this.add((Component)this.typingArea, "First");
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jButton, "Last");
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.displayInfo(keyEvent, "KEY TYPED: ");
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.displayInfo(keyEvent, "KEY PRESSED: ");
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.displayInfo(keyEvent, "KEY RELEASED: ");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.displayArea.setText("");
        this.typingArea.setText("");
        this.typingArea.requestFocusInWindow();
    }

    protected void displayInfo(KeyEvent keyEvent, String string) {
        String string2;
        int n;
        int n2 = keyEvent.getID();
        if (n2 == 400) {
            n = keyEvent.getKeyChar();
            string2 = "key character = '" + (char)n + "'";
        } else {
            n = keyEvent.getKeyCode();
            string2 = "key code = " + n + " (" + KeyEvent.getKeyText(n) + ")";
        }
        n = keyEvent.getModifiersEx();
        String string3 = "modifiers = " + n;
        String string4 = KeyEvent.getModifiersExText(n);
        string3 = string4.length() > 0 ? string3 + " (" + string4 + ")" : string3 + " (no modifiers)";
        String string5 = "action key? ";
        string5 = keyEvent.isActionKey() ? string5 + "YES" : string5 + "NO";
        String string6 = "key location: ";
        int n3 = keyEvent.getKeyLocation();
        string6 = n3 == 1 ? string6 + "standard" : (n3 == 2 ? string6 + "left" : (n3 == 3 ? string6 + "right" : (n3 == 4 ? string6 + "numpad" : string6 + "unknown")));
        this.displayArea.append(string + newline + "    " + string2 + newline + "    " + string3 + newline + "    " + string5 + newline + "    " + string6 + newline);
        this.displayArea.setCaretPosition(this.displayArea.getDocument().getLength());
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("KeyEventDemo");
        jFrame.setDefaultCloseOperation(3);
        KeyEventDemo keyEventDemo = new KeyEventDemo();
        keyEventDemo.setOpaque(true);
        jFrame.setContentPane(keyEventDemo);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                KeyEventDemo.createAndShowGUI();
            }
        });
    }
}

