/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class MouseWheelEventDemo
extends JPanel
implements MouseWheelListener {
    JTextArea textArea = new JTextArea();
    JScrollPane scrollPane;
    static final String newline = "\n";

    public MouseWheelEventDemo() {
        super(new BorderLayout());
        this.textArea.setEditable(false);
        this.scrollPane = new JScrollPane(this.textArea);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setPreferredSize(new Dimension(400, 250));
        this.add((Component)this.scrollPane, "Center");
        this.textArea.append("This text area displays information about its mouse wheel events.\n");
        this.textArea.addMouseWheelListener(this);
        this.setPreferredSize(new Dimension(450, 350));
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        String string = n < 0 ? "Mouse wheel moved UP " + -n + " notch(es)" + newline : "Mouse wheel moved DOWN " + n + " notch(es)" + newline;
        if (mouseWheelEvent.getScrollType() == 0) {
            string = string + "    Scroll type: WHEEL_UNIT_SCROLL\n";
            string = string + "    Scroll amount: " + mouseWheelEvent.getScrollAmount() + " unit increments per notch" + newline;
            string = string + "    Units to scroll: " + mouseWheelEvent.getUnitsToScroll() + " unit increments" + newline;
            string = string + "    Vertical unit increment: " + this.scrollPane.getVerticalScrollBar().getUnitIncrement(1) + " pixels" + newline;
        } else {
            string = string + "    Scroll type: WHEEL_BLOCK_SCROLL\n";
            string = string + "    Vertical block increment: " + this.scrollPane.getVerticalScrollBar().getBlockIncrement(1) + " pixels" + newline;
        }
        this.saySomething(string, mouseWheelEvent);
    }

    void saySomething(String string, MouseWheelEvent mouseWheelEvent) {
        this.textArea.append(mouseWheelEvent.getComponent().getClass().getName() + ": " + string);
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("MouseWheelEventDemo");
        jFrame.setDefaultCloseOperation(3);
        MouseWheelEventDemo mouseWheelEventDemo = new MouseWheelEventDemo();
        mouseWheelEventDemo.setOpaque(true);
        jFrame.setContentPane(mouseWheelEventDemo);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MouseWheelEventDemo.createAndShowGUI();
            }
        });
    }
}

