/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CelsiusConverter2
implements ActionListener {
    private JFrame converterFrame = new JFrame("Convert Celsius to Fahrenheit");
    private JPanel converterPanel;
    private JFormattedTextField tempCelsius;
    private JLabel celsiusLabel;
    private JLabel fahrenheitLabel;
    private JButton convertTemp;

    public CelsiusConverter2() {
        this.converterFrame.setDefaultCloseOperation(3);
        this.converterPanel = new JPanel(new GridLayout(2, 2));
        this.addWidgets();
        this.converterFrame.getRootPane().setDefaultButton(this.convertTemp);
        this.converterFrame.add((Component)this.converterPanel, "Center");
        this.converterFrame.pack();
        this.converterFrame.setSize(this.converterFrame.getWidth() + 50, this.converterFrame.getHeight());
        this.converterFrame.setVisible(true);
    }

    private void addWidgets() {
        ImageIcon imageIcon = CelsiusConverter2.createImageIcon("images/convert.gif", "Convert temperature");
        this.tempCelsius = new JFormattedTextField(new DecimalFormat("##0.0#"));
        this.tempCelsius.setFocusLostBehavior(1);
        try {
            this.tempCelsius.setText("37.0");
            this.tempCelsius.commitEdit();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        this.celsiusLabel = new JLabel("Celsius", 2);
        this.convertTemp = new JButton(imageIcon);
        this.fahrenheitLabel = new JLabel("Fahrenheit", 2);
        this.celsiusLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.fahrenheitLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.convertTemp.addActionListener(this);
        this.tempCelsius.addActionListener(this);
        this.converterPanel.add(this.tempCelsius);
        this.converterPanel.add(this.celsiusLabel);
        this.converterPanel.add(this.convertTemp);
        this.converterPanel.add(this.fahrenheitLabel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        int n = (int)(Double.parseDouble(this.tempCelsius.getText()) * 1.8 + 32.0);
        if (n <= 32) {
            this.fahrenheitLabel.setText("<html><font color=#00FFFF>" + n + "&#176 </font> Fahrenheit</html>");
        } else if (n <= 80) {
            this.fahrenheitLabel.setText("<html><font color=#00FF00>" + n + "&#176 </font> Fahrenheit</html>");
        } else {
            this.fahrenheitLabel.setText("<html><font color=#FF8040>" + n + "&#176 </font> Fahrenheit</html>");
        }
    }

    protected static ImageIcon createImageIcon(String string, String string2) {
        URL uRL = CelsiusConverter2.class.getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL, string2);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        CelsiusConverter2 celsiusConverter2 = new CelsiusConverter2();
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CelsiusConverter2.createAndShowGUI();
            }
        });
    }
}

