/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class LunarPhases
implements ActionListener {
    private static final int NUM_IMAGES = 8;
    private static final int START_INDEX = 3;
    private ImageIcon[] images = new ImageIcon[8];
    private JPanel mainPanel;
    private JPanel selectPanel = new JPanel();
    private JPanel displayPanel = new JPanel();
    private JComboBox phaseChoices = null;
    private JLabel phaseIconLabel = null;

    public LunarPhases() {
        this.addWidgets();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 3));
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.mainPanel.add(this.selectPanel);
        this.mainPanel.add(this.displayPanel);
    }

    private void addWidgets() {
        for (int i = 0; i < 8; ++i) {
            this.images[i] = LunarPhases.createImageIcon("/images/image" + i + ".jpg");
        }
        this.phaseIconLabel = new JLabel();
        this.phaseIconLabel.setHorizontalAlignment(0);
        this.phaseIconLabel.setVerticalAlignment(0);
        this.phaseIconLabel.setVerticalTextPosition(0);
        this.phaseIconLabel.setHorizontalTextPosition(0);
        this.phaseIconLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.phaseIconLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0), this.phaseIconLabel.getBorder()));
        String[] stringArray = new String[]{"New", "Waxing Crescent", "First Quarter", "Waxing Gibbous", "Full", "Waning Gibbous", "Third Quarter", "Waning Crescent"};
        this.phaseChoices = new JComboBox<String>(stringArray);
        this.phaseChoices.setSelectedIndex(3);
        this.phaseIconLabel.setIcon(this.images[3]);
        this.phaseIconLabel.setText("");
        this.selectPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Select Phase"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.displayPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Display Phase"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.displayPanel.add(this.phaseIconLabel);
        this.selectPanel.add(this.phaseChoices);
        this.phaseChoices.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("comboBoxChanged".equals(actionEvent.getActionCommand())) {
            this.phaseIconLabel.setIcon(this.images[this.phaseChoices.getSelectedIndex()]);
        }
    }

    protected static ImageIcon createImageIcon(String string) {
        URL uRL = LunarPhases.class.getResource(string);
        if (uRL == null) {
            System.err.println("Resource not found: " + string);
            return null;
        }
        return new ImageIcon(uRL);
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        LunarPhases lunarPhases = new LunarPhases();
        JFrame jFrame = new JFrame("Lunar Phases");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(lunarPhases.mainPanel);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LunarPhases.createAndShowGUI();
            }
        });
    }
}

