/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.NumberFormatter;

public class ConversionPanel
extends JPanel
implements ActionListener,
ChangeListener,
PropertyChangeListener {
    JFormattedTextField textField;
    JComboBox unitChooser;
    JSlider slider;
    ConverterRangeModel sliderModel;
    Converter controller;
    Unit[] units;
    String title;
    NumberFormat numberFormat;
    static final boolean MULTICOLORED = false;
    static final int MAX = 10000;

    ConversionPanel(Converter converter, String string, Unit[] unitArray, ConverterRangeModel converterRangeModel) {
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(string), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.controller = converter;
        this.units = unitArray;
        this.title = string;
        this.sliderModel = converterRangeModel;
        this.numberFormat = NumberFormat.getNumberInstance();
        this.numberFormat.setMaximumFractionDigits(2);
        NumberFormatter numberFormatter = new NumberFormatter(this.numberFormat);
        numberFormatter.setAllowsInvalid(false);
        numberFormatter.setCommitsOnValidEdit(true);
        this.textField = new JFormattedTextField(numberFormatter);
        this.textField.setColumns(10);
        this.textField.setValue(new Double(this.sliderModel.getDoubleValue()));
        this.textField.addPropertyChangeListener(this);
        this.unitChooser = new JComboBox();
        for (int i = 0; i < this.units.length; ++i) {
            this.unitChooser.addItem(this.units[i].description);
        }
        this.unitChooser.setSelectedIndex(0);
        this.sliderModel.setMultiplier(this.units[0].multiplier);
        this.unitChooser.addActionListener(this);
        this.slider = new JSlider(this.sliderModel);
        this.sliderModel.addChangeListener(this);
        JPanel jPanel = new JPanel(){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            public Dimension getPreferredSize() {
                return new Dimension(150, super.getPreferredSize().height);
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        jPanel.add(this.textField);
        jPanel.add(this.slider);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 3));
        jPanel2.add(this.unitChooser);
        jPanel2.add(Box.createHorizontalStrut(100));
        this.setLayout(new BoxLayout(this, 2));
        this.add(jPanel);
        this.add(jPanel2);
        jPanel.setAlignmentY(0.0f);
        jPanel2.setAlignmentY(0.0f);
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, this.getPreferredSize().height);
    }

    public double getMultiplier() {
        return this.sliderModel.getMultiplier();
    }

    public double getValue() {
        return this.sliderModel.getDoubleValue();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.sliderModel.getMinimum();
        int n2 = this.sliderModel.getMaximum();
        double d = this.sliderModel.getDoubleValue();
        NumberFormatter numberFormatter = (NumberFormatter)this.textField.getFormatter();
        numberFormatter.setMinimum(new Double(n));
        numberFormatter.setMaximum(new Double(n2));
        this.textField.setValue(new Double(d));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.unitChooser.getSelectedIndex();
        this.sliderModel.setMultiplier(this.units[n].multiplier);
        this.controller.resetMaxValues(false);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("value".equals(propertyChangeEvent.getPropertyName())) {
            Number number = (Number)propertyChangeEvent.getNewValue();
            this.sliderModel.setDoubleValue(number.doubleValue());
        }
    }
}

