/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class FormatterFactoryDemo
extends JPanel
implements PropertyChangeListener {
    private double amount = 100000.0;
    private double rate = 0.075;
    private int numPeriods = 30;
    private JLabel amountLabel;
    private JLabel rateLabel;
    private JLabel numPeriodsLabel;
    private JLabel paymentLabel;
    private static String amountString = "Loan Amount: ";
    private static String rateString = "APR (%): ";
    private static String numPeriodsString = "Years: ";
    private static String paymentString = "Monthly Payment: ";
    private JFormattedTextField amountField;
    private JFormattedTextField rateField;
    private JFormattedTextField numPeriodsField;
    private JFormattedTextField paymentField;
    private NumberFormat amountDisplayFormat;
    private NumberFormat amountEditFormat;
    private NumberFormat percentDisplayFormat;
    private NumberFormat percentEditFormat;
    private NumberFormat paymentFormat;

    public FormatterFactoryDemo() {
        super(new BorderLayout());
        this.setUpFormats();
        double d = this.computePayment(this.amount, this.rate, this.numPeriods);
        this.amountLabel = new JLabel(amountString);
        this.rateLabel = new JLabel(rateString);
        this.numPeriodsLabel = new JLabel(numPeriodsString);
        this.paymentLabel = new JLabel(paymentString);
        this.amountField = new JFormattedTextField(new DefaultFormatterFactory(new NumberFormatter(this.amountDisplayFormat), new NumberFormatter(this.amountDisplayFormat), new NumberFormatter(this.amountEditFormat)));
        this.amountField.setValue(new Double(this.amount));
        this.amountField.setColumns(10);
        this.amountField.addPropertyChangeListener("value", this);
        NumberFormatter numberFormatter = new NumberFormatter(this.percentEditFormat){

            public String valueToString(Object object) throws ParseException {
                Number number = (Number)object;
                if (number != null) {
                    double d = number.doubleValue() * 100.0;
                    number = new Double(d);
                }
                return super.valueToString(number);
            }

            public Object stringToValue(String string) throws ParseException {
                Number number = (Number)super.stringToValue(string);
                if (number != null) {
                    double d = number.doubleValue() / 100.0;
                    number = new Double(d);
                }
                return number;
            }
        };
        this.rateField = new JFormattedTextField(new DefaultFormatterFactory(new NumberFormatter(this.percentDisplayFormat), new NumberFormatter(this.percentDisplayFormat), numberFormatter));
        this.rateField.setValue(new Double(this.rate));
        this.rateField.setColumns(10);
        this.rateField.addPropertyChangeListener("value", this);
        this.numPeriodsField = new JFormattedTextField();
        this.numPeriodsField.setValue(new Integer(this.numPeriods));
        this.numPeriodsField.setColumns(10);
        this.numPeriodsField.addPropertyChangeListener("value", this);
        this.paymentField = new JFormattedTextField(this.paymentFormat);
        this.paymentField.setValue(new Double(d));
        this.paymentField.setColumns(10);
        this.paymentField.setEditable(false);
        this.paymentField.setForeground(Color.red);
        this.amountLabel.setLabelFor(this.amountField);
        this.rateLabel.setLabelFor(this.rateField);
        this.numPeriodsLabel.setLabelFor(this.numPeriodsField);
        this.paymentLabel.setLabelFor(this.paymentField);
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.add(this.amountLabel);
        jPanel.add(this.rateLabel);
        jPanel.add(this.numPeriodsLabel);
        jPanel.add(this.paymentLabel);
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
        jPanel2.add(this.amountField);
        jPanel2.add(this.rateField);
        jPanel2.add(this.numPeriodsField);
        jPanel2.add(this.paymentField);
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel2, "After");
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        if (object == this.amountField) {
            this.amount = ((Number)this.amountField.getValue()).doubleValue();
        } else if (object == this.rateField) {
            this.rate = ((Number)this.rateField.getValue()).doubleValue();
        } else if (object == this.numPeriodsField) {
            this.numPeriods = ((Number)this.numPeriodsField.getValue()).intValue();
        }
        double d = this.computePayment(this.amount, this.rate, this.numPeriods);
        this.paymentField.setValue(new Double(d));
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("FormatterFactoryDemo");
        jFrame.setDefaultCloseOperation(3);
        FormatterFactoryDemo formatterFactoryDemo = new FormatterFactoryDemo();
        formatterFactoryDemo.setOpaque(true);
        jFrame.setContentPane(formatterFactoryDemo);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FormatterFactoryDemo.createAndShowGUI();
            }
        });
    }

    double computePayment(double d, double d2, int n) {
        double d3;
        n *= 12;
        if (d2 > 0.001) {
            double d4 = d2 / 12.0;
            double d5 = Math.pow(1.0 + d4, 0.0 - (double)n);
            d3 = (1.0 - d5) / d4;
        } else {
            d3 = n;
        }
        double d6 = -1.0 * d / d3;
        return d6;
    }

    private void setUpFormats() {
        this.amountDisplayFormat = NumberFormat.getCurrencyInstance();
        this.amountDisplayFormat.setMinimumFractionDigits(0);
        this.amountEditFormat = NumberFormat.getNumberInstance();
        this.percentDisplayFormat = NumberFormat.getPercentInstance();
        this.percentDisplayFormat.setMinimumFractionDigits(2);
        this.percentEditFormat = NumberFormat.getNumberInstance();
        this.percentEditFormat.setMinimumFractionDigits(2);
        this.paymentFormat = NumberFormat.getCurrencyInstance();
    }
}

