/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class RootLayeredPaneDemo
extends JPanel
implements ActionListener,
MouseMotionListener {
    private int[] layers = new int[]{-30000, 0, 301};
    private String[] layerStrings = new String[]{"Yellow (-30000)", "Magenta (0)", "Cyan (301)"};
    private Color[] layerColors = new Color[]{Color.yellow, Color.magenta, Color.cyan};
    private JLayeredPane layeredPane;
    private JLabel dukeLabel;
    private JCheckBox onTop;
    private JComboBox layerList;
    private static String ON_TOP_COMMAND = "ontop";
    private static String LAYER_COMMAND = "layer";
    private static final int XFUDGE = 40;
    private static final int YFUDGE = 57;
    private static final int INITIAL_DUKE_LAYER_INDEX = 1;
    static /* synthetic */ Class class$RootLayeredPaneDemo;

    public RootLayeredPaneDemo(JLayeredPane jLayeredPane) {
        super(new GridLayout(1, 1));
        ImageIcon imageIcon = RootLayeredPaneDemo.createImageIcon("images/dukeWaveRed.gif");
        this.layeredPane = jLayeredPane;
        jLayeredPane.addMouseMotionListener(this);
        Point point = new Point(10, 100);
        int n = 35;
        for (int i = 0; i < this.layerStrings.length; ++i) {
            JLabel jLabel = this.createColoredLabel(this.layerStrings[i], this.layerColors[i], point);
            jLayeredPane.add((Component)jLabel, new Integer(this.layers[i]));
            point.x += n;
            point.y += n;
        }
        this.dukeLabel = new JLabel(imageIcon);
        if (imageIcon != null) {
            this.dukeLabel.setBounds(15, 225, imageIcon.getIconWidth(), imageIcon.getIconHeight());
        } else {
            System.err.println("Duke icon not found; using black square instead.");
            this.dukeLabel.setBounds(15, 225, 30, 30);
            this.dukeLabel.setOpaque(true);
            this.dukeLabel.setBackground(Color.BLACK);
        }
        jLayeredPane.add(this.dukeLabel, new Integer(this.layers[1]), 0);
        this.add(this.createControlPanel());
    }

    protected static ImageIcon createImageIcon(String string) {
        URL uRL = (class$RootLayeredPaneDemo == null ? (class$RootLayeredPaneDemo = RootLayeredPaneDemo.class$("RootLayeredPaneDemo")) : class$RootLayeredPaneDemo).getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }

    private JLabel createColoredLabel(String string, Color color, Point point) {
        JLabel jLabel = new JLabel(string);
        jLabel.setVerticalAlignment(1);
        jLabel.setHorizontalAlignment(0);
        jLabel.setOpaque(true);
        jLabel.setBackground(color);
        jLabel.setForeground(Color.black);
        jLabel.setBorder(BorderFactory.createLineBorder(Color.black));
        jLabel.setBounds(point.x, point.y, 140, 140);
        return jLabel;
    }

    private JPanel createControlPanel() {
        this.onTop = new JCheckBox("Top Position in Layer");
        this.onTop.setSelected(true);
        this.onTop.setActionCommand(ON_TOP_COMMAND);
        this.onTop.addActionListener(this);
        this.layerList = new JComboBox<String>(this.layerStrings);
        this.layerList.setSelectedIndex(1);
        this.layerList.setActionCommand(LAYER_COMMAND);
        this.layerList.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(this.layerList);
        jPanel.add(this.onTop);
        jPanel.setBorder(BorderFactory.createTitledBorder("Choose Duke's Layer and Position"));
        return jPanel;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.dukeLabel.setLocation(mouseEvent.getX() - 40, mouseEvent.getY() - 57);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (ON_TOP_COMMAND.equals(string)) {
            if (this.onTop.isSelected()) {
                this.layeredPane.moveToFront(this.dukeLabel);
            } else {
                this.layeredPane.moveToBack(this.dukeLabel);
            }
        } else if (LAYER_COMMAND.equals(string)) {
            int n = this.onTop.isSelected() ? 0 : -1;
            this.layeredPane.setLayer(this.dukeLabel, this.layers[this.layerList.getSelectedIndex()], n);
        }
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("RootLayeredPaneDemo");
        jFrame.setDefaultCloseOperation(3);
        RootLayeredPaneDemo rootLayeredPaneDemo = new RootLayeredPaneDemo(jFrame.getLayeredPane());
        rootLayeredPaneDemo.setOpaque(true);
        jFrame.setContentPane(rootLayeredPaneDemo);
        jFrame.setSize(new Dimension(300, 350));
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RootLayeredPaneDemo.createAndShowGUI();
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

