/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TableRenderDemo
extends JPanel {
    private boolean DEBUG = false;

    public TableRenderDemo() {
        super(new GridLayout(1, 0));
        JTable jTable = new JTable(new MyTableModel());
        jTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.initColumnSizes(jTable);
        this.setUpSportColumn(jTable, jTable.getColumnModel().getColumn(2));
        this.add(jScrollPane);
    }

    private void initColumnSizes(JTable jTable) {
        MyTableModel myTableModel = (MyTableModel)jTable.getModel();
        TableColumn tableColumn = null;
        Component component = null;
        int n = 0;
        int n2 = 0;
        Object[] objectArray = myTableModel.longValues;
        TableCellRenderer tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        for (int i = 0; i < 5; ++i) {
            tableColumn = jTable.getColumnModel().getColumn(i);
            component = tableCellRenderer.getTableCellRendererComponent(null, tableColumn.getHeaderValue(), false, false, 0, 0);
            n = component.getPreferredSize().width;
            component = jTable.getDefaultRenderer(myTableModel.getColumnClass(i)).getTableCellRendererComponent(jTable, objectArray[i], false, false, 0, i);
            n2 = component.getPreferredSize().width;
            if (this.DEBUG) {
                System.out.println("Initializing width of column " + i + ". " + "headerWidth = " + n + "; cellWidth = " + n2);
            }
            tableColumn.setPreferredWidth(Math.max(n, n2));
        }
    }

    public void setUpSportColumn(JTable jTable, TableColumn tableColumn) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("Snowboarding");
        jComboBox.addItem("Rowing");
        jComboBox.addItem("Knitting");
        jComboBox.addItem("Speed reading");
        jComboBox.addItem("Pool");
        jComboBox.addItem("None of the above");
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setToolTipText("Click for combo box");
        tableColumn.setCellRenderer(defaultTableCellRenderer);
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("TableRenderDemo");
        jFrame.setDefaultCloseOperation(3);
        TableRenderDemo tableRenderDemo = new TableRenderDemo();
        tableRenderDemo.setOpaque(true);
        jFrame.setContentPane(tableRenderDemo);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TableRenderDemo.createAndShowGUI();
            }
        });
    }

    class MyTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"First Name", "Last Name", "Sport", "# of Years", "Vegetarian"};
        private Object[][] data = new Object[][]{{"Mary", "Campione", "Snowboarding", new Integer(5), new Boolean(false)}, {"Alison", "Huml", "Rowing", new Integer(3), new Boolean(true)}, {"Kathy", "Walrath", "Knitting", new Integer(2), new Boolean(false)}, {"Sharon", "Zakhour", "Speed reading", new Integer(20), new Boolean(true)}, {"Philip", "Milne", "Pool", new Integer(10), new Boolean(false)}};
        public final Object[] longValues = new Object[]{"Sharon", "Campione", "None of the above", new Integer(20), Boolean.TRUE};

        MyTableModel() {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 >= 2;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (TableRenderDemo.this.DEBUG) {
                System.out.println("Setting value at " + n + "," + n2 + " to " + object + " (an instance of " + object.getClass() + ")");
            }
            this.data[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
            if (TableRenderDemo.this.DEBUG) {
                System.out.println("New value of data:");
                this.printDebugData();
            }
        }

        private void printDebugData() {
            int n = this.getRowCount();
            int n2 = this.getColumnCount();
            for (int i = 0; i < n; ++i) {
                System.out.print("    row " + i + ":");
                for (int j = 0; j < n2; ++j) {
                    System.out.print("  " + this.data[i][j]);
                }
                System.out.println();
            }
            System.out.println("--------------------------");
        }
    }
}

