/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class TextSamplerDemo
extends JPanel
implements ActionListener {
    private String newline = "\n";
    protected static final String textFieldString = "JTextField";
    protected static final String passwordFieldString = "JPasswordField";
    protected static final String ftfString = "JFormattedTextField";
    protected static final String buttonString = "JButton";
    protected JLabel actionLabel;
    static /* synthetic */ Class class$TextSamplerDemo;

    public TextSamplerDemo() {
        this.setLayout(new BorderLayout());
        JTextField jTextField = new JTextField(10);
        jTextField.setActionCommand(textFieldString);
        jTextField.addActionListener(this);
        JPasswordField jPasswordField = new JPasswordField(10);
        jPasswordField.setActionCommand(passwordFieldString);
        jPasswordField.addActionListener(this);
        JFormattedTextField jFormattedTextField = new JFormattedTextField(Calendar.getInstance().getTime());
        jFormattedTextField.setActionCommand(textFieldString);
        jFormattedTextField.addActionListener(this);
        JLabel jLabel = new JLabel("JTextField: ");
        jLabel.setLabelFor(jTextField);
        JLabel jLabel2 = new JLabel("JPasswordField: ");
        jLabel2.setLabelFor(jPasswordField);
        JLabel jLabel3 = new JLabel("JFormattedTextField: ");
        jLabel3.setLabelFor(jFormattedTextField);
        this.actionLabel = new JLabel("Type text and then Enter in a field.");
        this.actionLabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        JLabel[] jLabelArray = new JLabel[]{jLabel, jLabel2, jLabel3};
        JTextField[] jTextFieldArray = new JTextField[]{jTextField, jPasswordField, jFormattedTextField};
        this.addLabelTextRows(jLabelArray, jTextFieldArray, gridBagLayout, jPanel);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.actionLabel, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Text Fields"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JTextArea jTextArea = new JTextArea("This is an editable JTextArea. A text area is a \"plain\" text component, which means that although it can display text in any font, all of the text is in the same font.");
        jTextArea.setFont(new Font("Serif", 2, 16));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(250, 250));
        jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Plain Text"), BorderFactory.createEmptyBorder(5, 5, 5, 5)), jScrollPane.getBorder()));
        JEditorPane jEditorPane = this.createEditorPane();
        JScrollPane jScrollPane2 = new JScrollPane(jEditorPane);
        jScrollPane2.setVerticalScrollBarPolicy(22);
        jScrollPane2.setPreferredSize(new Dimension(250, 145));
        jScrollPane2.setMinimumSize(new Dimension(10, 10));
        JTextPane jTextPane = this.createTextPane();
        JScrollPane jScrollPane3 = new JScrollPane(jTextPane);
        jScrollPane3.setVerticalScrollBarPolicy(22);
        jScrollPane3.setPreferredSize(new Dimension(250, 155));
        jScrollPane3.setMinimumSize(new Dimension(10, 10));
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane2, jScrollPane3);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(0.5);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 0));
        jPanel2.add(jSplitPane);
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Styled Text"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "First");
        jPanel3.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel3, "Before");
        this.add((Component)jPanel2, "After");
    }

    private void addLabelTextRows(JLabel[] jLabelArray, JTextField[] jTextFieldArray, GridBagLayout gridBagLayout, Container container) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        int n = jLabelArray.length;
        for (int i = 0; i < n; ++i) {
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            container.add((Component)jLabelArray[i], gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            container.add((Component)jTextFieldArray[i], gridBagConstraints);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = "You typed \"";
        if (textFieldString.equals(actionEvent.getActionCommand())) {
            JTextField jTextField = (JTextField)actionEvent.getSource();
            this.actionLabel.setText(string + jTextField.getText() + "\"");
        } else if (passwordFieldString.equals(actionEvent.getActionCommand())) {
            JPasswordField jPasswordField = (JPasswordField)actionEvent.getSource();
            this.actionLabel.setText(string + new String(jPasswordField.getPassword()) + "\"");
        } else if (buttonString.equals(actionEvent.getActionCommand())) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private JEditorPane createEditorPane() {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        URL uRL = (class$TextSamplerDemo == null ? (class$TextSamplerDemo = TextSamplerDemo.class$("TextSamplerDemo")) : class$TextSamplerDemo).getResource("TextSamplerDemoHelp.html");
        if (uRL != null) {
            try {
                jEditorPane.setPage(uRL);
            }
            catch (IOException iOException) {
                System.err.println("Attempted to read a bad URL: " + uRL);
            }
        } else {
            System.err.println("Couldn't find file: TextSampleDemoHelp.html");
        }
        return jEditorPane;
    }

    private JTextPane createTextPane() {
        String[] stringArray = new String[]{"This is an editable JTextPane, ", "another ", "styled ", "text ", "component, ", "which supports embedded components..." + this.newline, " " + this.newline, "...and embedded icons..." + this.newline, " ", this.newline + "JTextPane is a subclass of JEditorPane that " + "uses a StyledEditorKit and StyledDocument, and provides " + "cover methods for interacting with those objects."};
        String[] stringArray2 = new String[]{"regular", "italic", "bold", "small", "large", "regular", "button", "regular", "icon", "regular"};
        JTextPane jTextPane = new JTextPane();
        StyledDocument styledDocument = jTextPane.getStyledDocument();
        this.addStylesToDocument(styledDocument);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                styledDocument.insertString(styledDocument.getLength(), stringArray[i], styledDocument.getStyle(stringArray2[i]));
            }
        }
        catch (BadLocationException badLocationException) {
            System.err.println("Couldn't insert initial text into text pane.");
        }
        return jTextPane;
    }

    protected void addStylesToDocument(StyledDocument styledDocument) {
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        Style style2 = styledDocument.addStyle("regular", style);
        StyleConstants.setFontFamily(style, "SansSerif");
        Style style3 = styledDocument.addStyle("italic", style2);
        StyleConstants.setItalic(style3, true);
        style3 = styledDocument.addStyle("bold", style2);
        StyleConstants.setBold(style3, true);
        style3 = styledDocument.addStyle("small", style2);
        StyleConstants.setFontSize(style3, 10);
        style3 = styledDocument.addStyle("large", style2);
        StyleConstants.setFontSize(style3, 16);
        style3 = styledDocument.addStyle("icon", style2);
        StyleConstants.setAlignment(style3, 1);
        ImageIcon imageIcon = TextSamplerDemo.createImageIcon("images/Pig.gif", "a cute pig");
        if (imageIcon != null) {
            StyleConstants.setIcon(style3, imageIcon);
        }
        style3 = styledDocument.addStyle("button", style2);
        StyleConstants.setAlignment(style3, 1);
        ImageIcon imageIcon2 = TextSamplerDemo.createImageIcon("images/sound.gif", "sound icon");
        JButton jButton = new JButton();
        if (imageIcon2 != null) {
            jButton.setIcon(imageIcon2);
        } else {
            jButton.setText("BEEP");
        }
        jButton.setCursor(Cursor.getDefaultCursor());
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setActionCommand(buttonString);
        jButton.addActionListener(this);
        StyleConstants.setComponent(style3, jButton);
    }

    protected static ImageIcon createImageIcon(String string, String string2) {
        URL uRL = (class$TextSamplerDemo == null ? (class$TextSamplerDemo = TextSamplerDemo.class$("TextSamplerDemo")) : class$TextSamplerDemo).getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL, string2);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("TextSamplerDemo");
        jFrame.setDefaultCloseOperation(3);
        TextSamplerDemo textSamplerDemo = new TextSamplerDemo();
        textSamplerDemo.setOpaque(true);
        jFrame.setContentPane(textSamplerDemo);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TextSamplerDemo.createAndShowGUI();
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

