/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.IOException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class TreeIconDemo
extends JPanel
implements TreeSelectionListener {
    private JEditorPane htmlPane;
    private JTree tree;
    private URL helpURL;
    private static boolean DEBUG = false;
    static /* synthetic */ Class class$TreeIconDemo;

    public TreeIconDemo() {
        super(new GridLayout(1, 0));
        JComponent jComponent;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("The Java Series");
        this.createNodes(defaultMutableTreeNode);
        this.tree = new JTree(defaultMutableTreeNode);
        this.tree.getSelectionModel().setSelectionMode(1);
        ImageIcon imageIcon = TreeIconDemo.createImageIcon("images/middle.gif");
        if (imageIcon != null) {
            jComponent = new DefaultTreeCellRenderer();
            ((DefaultTreeCellRenderer)jComponent).setLeafIcon(imageIcon);
            this.tree.setCellRenderer((TreeCellRenderer)((Object)jComponent));
        } else {
            System.err.println("Leaf icon missing; using default.");
        }
        this.tree.addTreeSelectionListener(this);
        jComponent = new JScrollPane(this.tree);
        this.htmlPane = new JEditorPane();
        this.htmlPane.setEditable(false);
        this.initHelp();
        JScrollPane jScrollPane = new JScrollPane(this.htmlPane);
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setTopComponent(jComponent);
        jSplitPane.setBottomComponent(jScrollPane);
        Dimension dimension = new Dimension(100, 50);
        jScrollPane.setMinimumSize(dimension);
        jComponent.setMinimumSize(dimension);
        jSplitPane.setDividerLocation(100);
        jSplitPane.setPreferredSize(new Dimension(500, 300));
        this.add(jSplitPane);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (defaultMutableTreeNode.isLeaf()) {
            BookInfo bookInfo = (BookInfo)object;
            this.displayURL(bookInfo.bookURL);
            if (DEBUG) {
                System.out.print(bookInfo.bookURL + ":  \n    ");
            }
        } else {
            this.displayURL(this.helpURL);
        }
        if (DEBUG) {
            System.out.println(object.toString());
        }
    }

    private void initHelp() {
        String string = "TreeDemoHelp.html";
        this.helpURL = (class$TreeIconDemo == null ? (class$TreeIconDemo = TreeIconDemo.class$("TreeIconDemo")) : class$TreeIconDemo).getResource(string);
        if (this.helpURL == null) {
            System.err.println("Couldn't open help file: " + string);
        } else if (DEBUG) {
            System.out.println("Help URL is " + this.helpURL);
        }
        this.displayURL(this.helpURL);
    }

    private void displayURL(URL uRL) {
        try {
            if (uRL != null) {
                this.htmlPane.setPage(uRL);
            } else {
                this.htmlPane.setText("File Not Found");
                if (DEBUG) {
                    System.out.println("Attempted to display a null URL.");
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("Attempted to read a bad URL: " + uRL);
        }
    }

    private void createNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("Books for Java Programmers");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode(new BookInfo("The Java Tutorial: A Short Course on the Basics", "tutorial.html"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode(new BookInfo("The Java Tutorial Continued: The Rest of the JDK", "tutorialcont.html"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode(new BookInfo("The JFC Swing Tutorial: A Guide to Constructing GUIs", "swingtutorial.html"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode(new BookInfo("Effective Java Programming Language Guide", "bloch.html"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode(new BookInfo("The Java Programming Language", "arnold.html"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode(new BookInfo("The Java Developers Almanac", "chan.html"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("Books for Java Implementers");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode(new BookInfo("The Java Virtual Machine Specification", "vm.html"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode(new BookInfo("The Java Language Specification", "jls.html"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
    }

    protected static ImageIcon createImageIcon(String string) {
        URL uRL = (class$TreeIconDemo == null ? (class$TreeIconDemo = TreeIconDemo.class$("TreeIconDemo")) : class$TreeIconDemo).getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("TreeIconDemo");
        jFrame.setDefaultCloseOperation(3);
        TreeIconDemo treeIconDemo = new TreeIconDemo();
        treeIconDemo.setOpaque(true);
        jFrame.setContentPane(treeIconDemo);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeIconDemo.createAndShowGUI();
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class BookInfo {
        public String bookName;
        public URL bookURL;

        public BookInfo(String string, String string2) {
            this.bookName = string;
            this.bookURL = (class$TreeIconDemo == null ? (class$TreeIconDemo = TreeIconDemo.class$("TreeIconDemo")) : class$TreeIconDemo).getResource(string2);
            if (this.bookURL == null) {
                System.err.println("Couldn't find file: " + string2);
            }
        }

        public String toString() {
            return this.bookName;
        }
    }
}

