/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class TreeIconDemo2
extends JPanel
implements TreeSelectionListener {
    private JEditorPane htmlPane;
    private JTree tree;
    private URL helpURL;
    private static boolean DEBUG = false;
    static /* synthetic */ Class class$TreeIconDemo;
    static /* synthetic */ Class class$TreeIconDemo2;

    public TreeIconDemo2() {
        super(new GridLayout(1, 0));
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("The Java Series");
        this.createNodes(defaultMutableTreeNode);
        this.tree = new JTree(defaultMutableTreeNode);
        this.tree.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        ImageIcon imageIcon = TreeIconDemo2.createImageIcon("images/middle.gif");
        if (imageIcon != null) {
            this.tree.setCellRenderer(new MyRenderer(imageIcon));
        } else {
            System.err.println("Tutorial icon missing; using default.");
        }
        this.tree.addTreeSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.htmlPane = new JEditorPane();
        this.htmlPane.setEditable(false);
        this.initHelp();
        JScrollPane jScrollPane2 = new JScrollPane(this.htmlPane);
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setTopComponent(jScrollPane);
        jSplitPane.setBottomComponent(jScrollPane2);
        Dimension dimension = new Dimension(100, 50);
        jScrollPane2.setMinimumSize(dimension);
        jScrollPane.setMinimumSize(dimension);
        jSplitPane.setDividerLocation(100);
        jSplitPane.setPreferredSize(new Dimension(500, 300));
        this.add(jSplitPane);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (defaultMutableTreeNode.isLeaf()) {
            BookInfo bookInfo = (BookInfo)object;
            this.displayURL(bookInfo.bookURL);
            if (DEBUG) {
                System.out.print(bookInfo.bookURL + ":  \n    ");
            }
        } else {
            this.displayURL(this.helpURL);
        }
        if (DEBUG) {
            System.out.println(object.toString());
        }
    }

    private void initHelp() {
        String string = "TreeDemoHelp.html";
        this.helpURL = (class$TreeIconDemo == null ? (class$TreeIconDemo = TreeIconDemo2.class$("TreeIconDemo")) : class$TreeIconDemo).getResource(string);
        if (this.helpURL == null) {
            System.err.println("Couldn't open help file: " + string);
        } else if (DEBUG) {
            System.out.println("Help URL is " + this.helpURL);
        }
        this.displayURL(this.helpURL);
    }

    private void displayURL(URL uRL) {
        try {
            if (uRL != null) {
                this.htmlPane.setPage(uRL);
            } else {
                this.htmlPane.setText("File Not Found");
                if (DEBUG) {
                    System.out.println("Attempted to display a null URL.");
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("Attempted to read a bad URL: " + uRL);
        }
    }

    private void createNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("Books for Java Programmers");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode(new BookInfo("The Java Tutorial: A Short Course on the Basics", "tutorial.html"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode(new BookInfo("The Java Tutorial Continued: The Rest of the JDK", "tutorialcont.html"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode(new BookInfo("The JFC Swing Tutorial: A Guide to Constructing GUIs", "swingtutorial.html"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode(new BookInfo("Effective Java Programming Language Guide", "bloch.html"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode(new BookInfo("The Java Programming Language", "arnold.html"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode(new BookInfo("The Java Developers Almanac", "chan.html"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("Books for Java Implementers");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode(new BookInfo("The Java Virtual Machine Specification", "vm.html"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode(new BookInfo("The Java Language Specification", "jls.html"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
    }

    protected static ImageIcon createImageIcon(String string) {
        URL uRL = (class$TreeIconDemo2 == null ? (class$TreeIconDemo2 = TreeIconDemo2.class$("TreeIconDemo2")) : class$TreeIconDemo2).getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("TreeIconDemo2");
        jFrame.setDefaultCloseOperation(3);
        TreeIconDemo2 treeIconDemo2 = new TreeIconDemo2();
        treeIconDemo2.setOpaque(true);
        jFrame.setContentPane(treeIconDemo2);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeIconDemo2.createAndShowGUI();
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MyRenderer
    extends DefaultTreeCellRenderer {
        Icon tutorialIcon;

        public MyRenderer(Icon icon) {
            this.tutorialIcon = icon;
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (bl3 && this.isTutorialBook(object)) {
                this.setIcon(this.tutorialIcon);
                this.setToolTipText("This book is in the Tutorial series.");
            } else {
                this.setToolTipText(null);
            }
            return this;
        }

        protected boolean isTutorialBook(Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            BookInfo bookInfo = (BookInfo)defaultMutableTreeNode.getUserObject();
            String string = bookInfo.bookName;
            return string.indexOf("Tutorial") >= 0;
        }
    }

    private class BookInfo {
        public String bookName;
        public URL bookURL;

        public BookInfo(String string, String string2) {
            this.bookName = string;
            this.bookURL = (class$TreeIconDemo == null ? (class$TreeIconDemo = TreeIconDemo2.class$("TreeIconDemo")) : class$TreeIconDemo).getResource(string2);
            if (this.bookURL == null) {
                System.err.println("Couldn't find file: " + string2);
            }
        }

        public String toString() {
            return this.bookName;
        }
    }
}

