/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class FocusEventDemo
extends JApplet
implements FocusListener,
ActionListener {
    JTextArea display;
    FocusWindow window;
    JButton b1;
    JButton b2;
    static final String SHOW = "show";
    static final String CLEAR = "clear";
    static final String newline = "\n";

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == SHOW) {
            this.window.pack();
            ((Component)this.window).setVisible(true);
        } else {
            this.display.setText("");
        }
    }

    void displayMessage(String string, FocusEvent focusEvent) {
        this.display.append(String.valueOf(string) + ": " + focusEvent.getComponent() + newline);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.displayMessage("Focus gained", focusEvent);
    }

    public void focusLost(FocusEvent focusEvent) {
        this.displayMessage("Focus lost", focusEvent);
    }

    public void init() {
        this.b1 = new JButton("Click to bring up a window.");
        this.b1.setActionCommand(SHOW);
        this.b1.addActionListener(this);
        this.b2 = new JButton("Click to clear the display.");
        this.b2.setActionCommand(CLEAR);
        this.b2.addActionListener(this);
        this.display = new JTextArea();
        this.display.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.display);
        jScrollPane.setPreferredSize(new Dimension(375, 125));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.b1, "North");
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)this.b2, "South");
        this.setContentPane(jPanel);
        this.window = new FocusWindow(this);
    }

    public void stop() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((Component)FocusEventDemo.this.window).setVisible(false);
            }
        });
    }
}

