/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class AccessibleScrollDemo
extends JPanel
implements ItemListener {
    private Rule columnView;
    private Rule rowView;
    private JToggleButton isMetric;
    private ScrollablePicture picture;
    static /* synthetic */ Class class$AccessibleScrollDemo;

    public AccessibleScrollDemo() {
        ImageIcon imageIcon = AccessibleScrollDemo.createImageIcon("images/youngdad.jpeg", "Photograph of David McNabb in his youth.");
        this.columnView = new Rule(0, true);
        if (imageIcon != null) {
            this.columnView.setPreferredWidth(imageIcon.getIconWidth());
        } else {
            this.columnView.setPreferredWidth(320);
        }
        this.columnView.getAccessibleContext().setAccessibleName("Column Header");
        this.columnView.getAccessibleContext().setAccessibleDescription("Displays horizontal ruler for measuring scroll pane client.");
        this.rowView = new Rule(1, true);
        if (imageIcon != null) {
            this.rowView.setPreferredHeight(imageIcon.getIconHeight());
        } else {
            this.rowView.setPreferredHeight(480);
        }
        this.rowView.getAccessibleContext().setAccessibleName("Row Header");
        this.rowView.getAccessibleContext().setAccessibleDescription("Displays vertical ruler for measuring scroll pane client.");
        JPanel jPanel = new JPanel();
        this.isMetric = new JToggleButton("cm", true);
        this.isMetric.setFont(new Font("SansSerif", 0, 11));
        this.isMetric.setMargin(new Insets(2, 2, 2, 2));
        this.isMetric.addItemListener(this);
        this.isMetric.setToolTipText("Toggles rulers' unit of measure between inches and centimeters.");
        jPanel.add(this.isMetric);
        jPanel.getAccessibleContext().setAccessibleName("Upper Left Corner");
        String string = "Fills the corner of a scroll pane with color for aesthetic reasons.";
        Corner corner = new Corner();
        corner.getAccessibleContext().setAccessibleName("Lower Left Corner");
        corner.getAccessibleContext().setAccessibleDescription(string);
        Corner corner2 = new Corner();
        corner2.getAccessibleContext().setAccessibleName("Upper Right Corner");
        corner2.getAccessibleContext().setAccessibleDescription(string);
        this.picture = new ScrollablePicture(imageIcon, this.columnView.getIncrement());
        this.picture.setToolTipText(imageIcon.getDescription());
        this.picture.getAccessibleContext().setAccessibleName("Scroll pane client");
        JScrollPane jScrollPane = new JScrollPane(this.picture);
        jScrollPane.setPreferredSize(new Dimension(300, 250));
        jScrollPane.setViewportBorder(BorderFactory.createLineBorder(Color.black));
        jScrollPane.setColumnHeaderView(this.columnView);
        jScrollPane.setRowHeaderView(this.rowView);
        jScrollPane.setCorner("UPPER_LEFT_CORNER", jPanel);
        jScrollPane.setCorner("LOWER_LEFT_CORNER", corner);
        jScrollPane.setCorner("UPPER_RIGHT_CORNER", corner2);
        this.setLayout(new BoxLayout(this, 0));
        this.add(jScrollPane);
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.rowView.setIsMetric(true);
            this.columnView.setIsMetric(true);
        } else {
            this.rowView.setIsMetric(false);
            this.columnView.setIsMetric(false);
        }
        this.picture.setMaxUnitIncrement(this.rowView.getIncrement());
    }

    protected static ImageIcon createImageIcon(String string, String string2) {
        URL uRL = (class$AccessibleScrollDemo == null ? (class$AccessibleScrollDemo = AccessibleScrollDemo.class$("AccessibleScrollDemo")) : class$AccessibleScrollDemo).getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL, string2);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("AccessibleScrollDemo");
        jFrame.setDefaultCloseOperation(3);
        AccessibleScrollDemo accessibleScrollDemo = new AccessibleScrollDemo();
        accessibleScrollDemo.setOpaque(true);
        jFrame.setContentPane(accessibleScrollDemo);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AccessibleScrollDemo.createAndShowGUI();
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

