/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;

class DTPicture
extends Picture
implements MouseMotionListener {
    private MouseEvent firstMouseEvent = null;
    private static boolean installInputMapBindings = true;

    public DTPicture(Image image) {
        super(image);
        Serializable serializable;
        this.addMouseMotionListener(this);
        if (installInputMapBindings) {
            serializable = this.getInputMap();
            ((InputMap)serializable).put(KeyStroke.getKeyStroke("ctrl X"), TransferHandler.getCutAction().getValue("Name"));
            ((InputMap)serializable).put(KeyStroke.getKeyStroke("ctrl C"), TransferHandler.getCopyAction().getValue("Name"));
            ((InputMap)serializable).put(KeyStroke.getKeyStroke("ctrl V"), TransferHandler.getPasteAction().getValue("Name"));
        }
        serializable = this.getActionMap();
        ((ActionMap)serializable).put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        ((ActionMap)serializable).put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        ((ActionMap)serializable).put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
    }

    public void setImage(Image image) {
        this.image = image;
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.image == null) {
            return;
        }
        this.firstMouseEvent = mouseEvent;
        mouseEvent.consume();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.image == null) {
            return;
        }
        if (this.firstMouseEvent != null) {
            mouseEvent.consume();
            int n = 128;
            int n2 = (mouseEvent.getModifiersEx() & n) == n ? 1 : 2;
            int n3 = Math.abs(mouseEvent.getX() - this.firstMouseEvent.getX());
            int n4 = Math.abs(mouseEvent.getY() - this.firstMouseEvent.getY());
            if (n3 > 5 || n4 > 5) {
                JComponent jComponent = (JComponent)mouseEvent.getSource();
                TransferHandler transferHandler = jComponent.getTransferHandler();
                transferHandler.exportAsDrag(jComponent, this.firstMouseEvent, n2);
                this.firstMouseEvent = null;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.firstMouseEvent = null;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public static void setInstallInputMapBindings(boolean bl) {
        installInputMapBindings = bl;
    }

    public static boolean getInstallInputMapBindingds() {
        return installInputMapBindings;
    }
}

