/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class InputVerificationDialogDemo
extends JPanel {
    private static double DEFAULT_AMOUNT = 100000.0;
    private static double DEFAULT_RATE = 7.5;
    private static int DEFAULT_PERIOD = 30;
    private JLabel amountLabel;
    private JLabel rateLabel;
    private JLabel numPeriodsLabel;
    private JLabel paymentLabel;
    private static String amountString = "Loan Amount (10,000 - 10,000,000): ";
    private static String rateString = "APR (>= 0%): ";
    private static String numPeriodsString = "Years (1-40): ";
    private static String paymentString = "Monthly Payment: ";
    private JTextField amountField;
    private JTextField rateField;
    private JTextField numPeriodsField;
    private JTextField paymentField;
    private NumberFormat moneyFormat;
    private NumberFormat percentFormat;
    private DecimalFormat decimalFormat;
    private DecimalFormat paymentFormat;
    private NumberFormat integerFormat;
    private MyVerifier verifier = new MyVerifier();

    public InputVerificationDialogDemo() {
        super(new BorderLayout());
        this.setUpFormats();
        double d = this.computePayment(DEFAULT_AMOUNT, DEFAULT_RATE, DEFAULT_PERIOD);
        this.amountLabel = new JLabel(amountString);
        this.rateLabel = new JLabel(rateString);
        this.numPeriodsLabel = new JLabel(numPeriodsString);
        this.paymentLabel = new JLabel(paymentString);
        this.amountField = new JTextField(this.moneyFormat.format(DEFAULT_AMOUNT), 10);
        this.amountField.setInputVerifier(this.verifier);
        this.rateField = new JTextField(this.percentFormat.format(DEFAULT_RATE), 10);
        this.rateField.setInputVerifier(this.verifier);
        this.numPeriodsField = new JTextField(this.decimalFormat.format(DEFAULT_PERIOD), 10);
        this.numPeriodsField.setInputVerifier(this.verifier);
        this.paymentField = new JTextField(this.paymentFormat.format(d), 10);
        this.paymentField.setInputVerifier(this.verifier);
        this.paymentField.setEditable(false);
        this.paymentField.setFocusable(false);
        this.paymentField.setForeground(Color.red);
        this.amountField.addActionListener(this.verifier);
        this.rateField.addActionListener(this.verifier);
        this.numPeriodsField.addActionListener(this.verifier);
        this.amountLabel.setLabelFor(this.amountField);
        this.rateLabel.setLabelFor(this.rateField);
        this.numPeriodsLabel.setLabelFor(this.numPeriodsField);
        this.paymentLabel.setLabelFor(this.paymentField);
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.add(this.amountLabel);
        jPanel.add(this.rateLabel);
        jPanel.add(this.numPeriodsLabel);
        jPanel.add(this.paymentLabel);
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
        jPanel2.add(this.amountField);
        jPanel2.add(this.rateField);
        jPanel2.add(this.numPeriodsField);
        jPanel2.add(this.paymentField);
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel2, "After");
    }

    private static void createAndShowGUI() {
        JFrame jFrame = new JFrame("InputVerificationDialogDemo");
        jFrame.setDefaultCloseOperation(3);
        InputVerificationDialogDemo inputVerificationDialogDemo = new InputVerificationDialogDemo();
        inputVerificationDialogDemo.setOpaque(true);
        jFrame.setContentPane(inputVerificationDialogDemo);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InputVerificationDialogDemo.createAndShowGUI();
            }
        });
    }

    double computePayment(double d, double d2, int n) {
        double d3;
        n *= 12;
        if (d2 > 0.01) {
            double d4 = d2 / 100.0 / 12.0;
            double d5 = Math.pow(1.0 + d4, 0.0 - (double)n);
            d3 = (1.0 - d5) / d4;
        } else {
            d3 = n;
        }
        double d6 = -1.0 * d / d3;
        return d6;
    }

    private void setUpFormats() {
        this.moneyFormat = NumberFormat.getNumberInstance();
        this.percentFormat = NumberFormat.getNumberInstance();
        this.percentFormat.setMinimumFractionDigits(3);
        this.decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance();
        this.decimalFormat.setParseIntegerOnly(true);
        this.paymentFormat = (DecimalFormat)NumberFormat.getNumberInstance();
        this.paymentFormat.setMaximumFractionDigits(2);
        this.paymentFormat.setNegativePrefix("(");
        this.paymentFormat.setNegativeSuffix(")");
        this.integerFormat = NumberFormat.getIntegerInstance();
    }

    class MyVerifier
    extends InputVerifier
    implements ActionListener {
        double MIN_AMOUNT = 10000.0;
        double MAX_AMOUNT = 1.0E7;
        double MIN_RATE = 0.0;
        int MIN_PERIOD = 1;
        int MAX_PERIOD = 40;
        String message = null;

        MyVerifier() {
        }

        public boolean shouldYieldFocus(JComponent jComponent) {
            boolean bl = this.verify(jComponent);
            this.makeItPretty(jComponent);
            this.updatePayment();
            if (bl) {
                return true;
            }
            jComponent.setInputVerifier(null);
            this.message = this.message + ".\nPlease try again.";
            JOptionPane.showMessageDialog(null, this.message, "Invalid Value", 2);
            jComponent.setInputVerifier(this);
            Toolkit.getDefaultToolkit().beep();
            return false;
        }

        protected void updatePayment() {
            double d = DEFAULT_AMOUNT;
            double d2 = DEFAULT_RATE;
            int n = DEFAULT_PERIOD;
            double d3 = 0.0;
            try {
                d = InputVerificationDialogDemo.this.moneyFormat.parse(InputVerificationDialogDemo.this.amountField.getText()).doubleValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            try {
                d2 = InputVerificationDialogDemo.this.percentFormat.parse(InputVerificationDialogDemo.this.rateField.getText()).doubleValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            try {
                n = InputVerificationDialogDemo.this.decimalFormat.parse(InputVerificationDialogDemo.this.numPeriodsField.getText()).intValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            d3 = InputVerificationDialogDemo.this.computePayment(d, d2, n);
            InputVerificationDialogDemo.this.paymentField.setText(InputVerificationDialogDemo.this.paymentFormat.format(d3));
        }

        public boolean verify(JComponent jComponent) {
            return this.checkField(jComponent, false);
        }

        protected void makeItPretty(JComponent jComponent) {
            this.checkField(jComponent, true);
        }

        protected boolean checkField(JComponent jComponent, boolean bl) {
            if (jComponent == InputVerificationDialogDemo.this.amountField) {
                return this.checkAmountField(bl);
            }
            if (jComponent == InputVerificationDialogDemo.this.rateField) {
                return this.checkRateField(bl);
            }
            if (jComponent == InputVerificationDialogDemo.this.numPeriodsField) {
                return this.checkNumPeriodsField(bl);
            }
            return true;
        }

        public boolean checkAmountField(boolean bl) {
            boolean bl2 = true;
            double d = DEFAULT_AMOUNT;
            try {
                d = InputVerificationDialogDemo.this.moneyFormat.parse(InputVerificationDialogDemo.this.amountField.getText()).doubleValue();
            }
            catch (ParseException parseException) {
                this.message = "Invalid money format in Loan Amount field";
                return false;
            }
            if (d < this.MIN_AMOUNT || d > this.MAX_AMOUNT) {
                bl2 = false;
                this.message = d < this.MIN_AMOUNT ? "Loan Amount was < " + InputVerificationDialogDemo.this.integerFormat.format(this.MIN_AMOUNT) : "Loan Amount was > " + InputVerificationDialogDemo.this.integerFormat.format(this.MAX_AMOUNT);
            }
            if (bl) {
                InputVerificationDialogDemo.this.amountField.setText(InputVerificationDialogDemo.this.moneyFormat.format(d));
                InputVerificationDialogDemo.this.amountField.selectAll();
            }
            return bl2;
        }

        public boolean checkRateField(boolean bl) {
            boolean bl2 = true;
            double d = DEFAULT_RATE;
            try {
                d = InputVerificationDialogDemo.this.percentFormat.parse(InputVerificationDialogDemo.this.rateField.getText()).doubleValue();
            }
            catch (ParseException parseException) {
                this.message = "Invalid percent format in APR field";
                return false;
            }
            if (d < this.MIN_RATE) {
                bl2 = false;
                this.message = "Bad value: APR was < " + this.MIN_RATE;
            }
            if (bl) {
                InputVerificationDialogDemo.this.rateField.setText(InputVerificationDialogDemo.this.percentFormat.format(d));
                InputVerificationDialogDemo.this.rateField.selectAll();
            }
            return bl2;
        }

        public boolean checkNumPeriodsField(boolean bl) {
            boolean bl2 = true;
            int n = DEFAULT_PERIOD;
            try {
                n = InputVerificationDialogDemo.this.decimalFormat.parse(InputVerificationDialogDemo.this.numPeriodsField.getText()).intValue();
            }
            catch (ParseException parseException) {
                this.message = "Invalid decimal format in Years field";
                return false;
            }
            if (n < this.MIN_PERIOD) {
                bl2 = false;
                this.message = "Bad value: Number of years was < " + InputVerificationDialogDemo.this.integerFormat.format(this.MIN_PERIOD);
            } else if (n > this.MAX_PERIOD) {
                bl2 = false;
                this.message = "Bad value: Number of years was > " + InputVerificationDialogDemo.this.integerFormat.format(this.MAX_PERIOD);
            }
            if (bl) {
                InputVerificationDialogDemo.this.numPeriodsField.setText(InputVerificationDialogDemo.this.decimalFormat.format(n));
                InputVerificationDialogDemo.this.numPeriodsField.selectAll();
            }
            return bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextField jTextField = (JTextField)actionEvent.getSource();
            this.shouldYieldFocus(jTextField);
            jTextField.selectAll();
        }
    }
}

