/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

class PictureTransferHandler
extends TransferHandler {
    DataFlavor pictureFlavor = DataFlavor.imageFlavor;
    DTPicture sourcePic;
    boolean shouldRemove;

    PictureTransferHandler() {
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        if (this.canImport(jComponent, transferable.getTransferDataFlavors())) {
            DTPicture dTPicture = (DTPicture)jComponent;
            if (this.sourcePic == dTPicture) {
                this.shouldRemove = false;
                return true;
            }
            try {
                Image image = (Image)transferable.getTransferData(this.pictureFlavor);
                dTPicture.setImage(image);
                return true;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                System.out.println("importData: unsupported data flavor");
            }
            catch (IOException iOException) {
                System.out.println("importData: I/O exception");
            }
        }
        return false;
    }

    protected Transferable createTransferable(JComponent jComponent) {
        this.sourcePic = (DTPicture)jComponent;
        this.shouldRemove = true;
        return new PictureTransferable(this.sourcePic);
    }

    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (this.shouldRemove && n == 2) {
            this.sourcePic.setImage(null);
        }
        this.sourcePic = null;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!this.pictureFlavor.equals(dataFlavorArray[i])) continue;
            return true;
        }
        return false;
    }

    class PictureTransferable
    implements Transferable {
        private Image image;

        PictureTransferable(DTPicture dTPicture) {
            this.image = dTPicture.image;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.image;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{PictureTransferHandler.this.pictureFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return PictureTransferHandler.this.pictureFlavor.equals(dataFlavor);
        }
    }
}

