/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class IconDemoApplet
extends JApplet
implements ActionListener {
    Vector<Photo> photos = new Vector();
    JButton previousButton;
    JButton nextButton;
    JLabel photographLabel;
    JLabel captionLabel;
    JLabel numberLabel;
    int current = 0;
    int widthOfWidest = 0;
    int heightOfTallest = 0;
    String imagedir = null;

    private void initializeGUI() {
        this.parseParameters();
        if (this.photos.size() == 0) {
            this.captionLabel = new JLabel("No images listed in applet tag.");
            this.captionLabel.setHorizontalAlignment(0);
            this.getContentPane().add(this.captionLabel);
            return;
        }
        this.numberLabel = new JLabel("Picture " + (this.current + 1) + " of " + this.photos.size());
        this.numberLabel.setHorizontalAlignment(2);
        this.numberLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        Photo photo = this.photos.firstElement();
        this.captionLabel = new JLabel(photo.caption);
        this.captionLabel.setHorizontalAlignment(0);
        this.captionLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.photographLabel = new JLabel("Loading first image...");
        this.photographLabel.setHorizontalAlignment(0);
        this.photographLabel.setVerticalAlignment(0);
        this.photographLabel.setVerticalTextPosition(0);
        this.photographLabel.setHorizontalTextPosition(0);
        this.photographLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.photographLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0), this.photographLabel.getBorder()));
        Insets insets = this.photographLabel.getInsets();
        this.photographLabel.setPreferredSize(new Dimension(this.widthOfWidest + insets.left + insets.right, this.heightOfTallest + insets.bottom + insets.top));
        ImageIcon imageIcon = IconDemoApplet.createAppletImageIcon("images/right.gif", "a right arrow");
        ImageIcon imageIcon2 = IconDemoApplet.createAppletImageIcon("images/dimmedRight.gif", "a dimmed right arrow");
        ImageIcon imageIcon3 = IconDemoApplet.createAppletImageIcon("images/left.gif", "a left arrow");
        ImageIcon imageIcon4 = IconDemoApplet.createAppletImageIcon("images/dimmedLeft.gif", "a dimmed left arrow");
        this.nextButton = new JButton("Next Picture", imageIcon);
        this.nextButton.setDisabledIcon(imageIcon2);
        this.nextButton.setVerticalTextPosition(0);
        this.nextButton.setHorizontalTextPosition(2);
        this.nextButton.setMnemonic(78);
        this.nextButton.setActionCommand("next");
        this.nextButton.addActionListener(this);
        this.previousButton = new JButton("Previous Picture", imageIcon3);
        this.previousButton.setDisabledIcon(imageIcon4);
        this.previousButton.setVerticalTextPosition(0);
        this.previousButton.setHorizontalTextPosition(4);
        this.previousButton.setMnemonic(80);
        this.previousButton.setActionCommand("previous");
        this.previousButton.addActionListener(this);
        this.previousButton.setEnabled(false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Container container = this.getContentPane();
        container.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.numberLabel, gridBagConstraints);
        container.add(this.numberLabel);
        gridBagLayout.setConstraints(this.captionLabel, gridBagConstraints);
        container.add(this.captionLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.photographLabel, gridBagConstraints);
        container.add(this.photographLabel);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.previousButton, gridBagConstraints);
        container.add(this.previousButton);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.nextButton, gridBagConstraints);
        container.add(this.nextButton);
        this.loadImage(this.imagedir + photo.filename, this.current);
    }

    @Override
    public void init() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IconDemoApplet.this.initializeGUI();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.photographLabel.setIcon(null);
        this.photographLabel.setText("Loading image...");
        if (actionEvent.getActionCommand().equals("next")) {
            ++this.current;
            if (!this.previousButton.isEnabled()) {
                this.previousButton.setEnabled(true);
            }
            if (this.current == this.photos.size() - 1) {
                this.nextButton.setEnabled(false);
            }
        } else {
            --this.current;
            if (!this.nextButton.isEnabled()) {
                this.nextButton.setEnabled(true);
            }
            if (this.current == 0) {
                this.previousButton.setEnabled(false);
            }
        }
        Photo photo = this.photos.elementAt(this.current);
        this.captionLabel.setText(photo.caption);
        this.numberLabel.setText("Picture " + (this.current + 1) + " of " + this.photos.size());
        if (photo.icon == null) {
            this.loadImage(this.imagedir + photo.filename, this.current);
        } else {
            this.updatePhotograph(photo);
        }
    }

    private void updatePhotograph(Photo photo) {
        ImageIcon imageIcon = photo.icon;
        this.photographLabel.setToolTipText(photo.filename + ": " + imageIcon.getIconWidth() + " X " + imageIcon.getIconHeight());
        this.photographLabel.setIcon(imageIcon);
        this.photographLabel.setText("");
    }

    private void loadImage(final String string, final int n) {
        new SwingWorker<ImageIcon, Void>(){

            @Override
            public ImageIcon doInBackground() {
                return IconDemoApplet.createAppletImageIcon(string, "photo #" + n);
            }

            @Override
            public void done() {
                Photo photo = IconDemoApplet.this.photos.elementAt(n);
                try {
                    photo.icon = (ImageIcon)this.get();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                    String string2 = null;
                    Throwable throwable = executionException.getCause();
                    string2 = throwable != null ? throwable.getMessage() : executionException.getMessage();
                    System.err.println("Error retrieving file: " + string2);
                }
                if (n == IconDemoApplet.this.current) {
                    IconDemoApplet.this.updatePhotograph(photo);
                }
            }
        }.execute();
    }

    private void parseParameters() {
        String string;
        String string2;
        int n = 0;
        while ((string2 = this.getParameter(string = "IMAGE" + n)) != null) {
            Photo photo = new Photo(string2, this.getCaption(n), this.getHeight(n), this.getWidth(n));
            this.photos.addElement(photo);
            ++n;
        }
        this.imagedir = this.getParameter("IMAGEDIR");
        if (this.imagedir != null) {
            this.imagedir = this.imagedir + "/";
        }
    }

    protected String getCaption(int n) {
        return this.getParameter("CAPTION" + n);
    }

    protected int getWidth(int n) {
        int n2 = 0;
        String string = this.getParameter("WIDTH" + n);
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
        } else {
            n2 = 0;
        }
        if (n2 > this.widthOfWidest) {
            this.widthOfWidest = n2;
        }
        return n2;
    }

    protected int getHeight(int n) {
        int n2 = 0;
        String string = this.getParameter("HEIGHT" + n);
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
        } else {
            n2 = 0;
        }
        if (n2 > this.heightOfTallest) {
            this.heightOfTallest = n2;
        }
        return n2;
    }

    @Override
    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"IMAGEDIR", "string", "directory containing image files"}, {"IMAGEN", "string", "filename"}, {"CAPTIONN", "string", "caption"}, {"WIDTHN", "integer", "width of image"}, {"HEIGHTN", "integer", "height of image"}};
        return stringArray;
    }

    protected static ImageIcon createAppletImageIcon(String string, String string2) {
        int n = 75000;
        int n2 = 0;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(IconDemoApplet.class.getResourceAsStream(string));
        if (bufferedInputStream != null) {
            byte[] byArray = new byte[n];
            try {
                n2 = bufferedInputStream.read(byArray);
            }
            catch (IOException iOException) {
                System.err.println("Couldn't read stream from file: " + string);
            }
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("Can't close file " + string);
            }
            if (n2 <= 0) {
                System.err.println("Empty file: " + string);
                return null;
            }
            return new ImageIcon(Toolkit.getDefaultToolkit().createImage(byArray), string2);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }

    class Photo {
        public String filename;
        public String caption;
        public int height;
        public int width;
        public ImageIcon icon = null;

        public Photo(String string, String string2, int n, int n2) {
            this.filename = string;
            this.caption = string2;
            this.height = n;
            this.width = n2;
        }
    }
}

