/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;

public class TreeExpandEventDemo2
extends JApplet {
    DemoArea demoArea;
    JTextArea textArea;
    static final String newline = "\n";

    public void init() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.demoArea = new DemoArea();
        gridBagLayout.setConstraints(this.demoArea, gridBagConstraints);
        jPanel.add(this.demoArea);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(200, 75));
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        this.setContentPane(jPanel);
    }

    void saySomething(String string, TreeExpansionEvent treeExpansionEvent) {
        this.textArea.append(String.valueOf(string) + "; " + "path = " + treeExpansionEvent.getPath() + newline);
    }

    class DemoArea
    extends JScrollPane
    implements TreeExpansionListener,
    TreeWillExpandListener {
        Dimension minSize = new Dimension(100, 100);
        JTree tree;
        Object[] willExpandOptions = new Object[]{"Cancel Expansion", "Expand"};
        String willExpandText = "A branch node is about to be expanded.\nClick \"Cancel Expansion\" to prevent it.";
        String willExpandTitle = "Tree Will Expand";

        public DemoArea() {
            TreeNode treeNode = this.createNodes();
            this.tree = new JTree(treeNode);
            this.tree.addTreeExpansionListener(this);
            this.tree.addTreeWillExpandListener(this);
            this.setViewportView(this.tree);
        }

        private TreeNode createNodes() {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("San Francisco");
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Potrero Hill");
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Restaurants");
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("Thai Barbeque");
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
            defaultMutableTreeNode4 = new DefaultMutableTreeNode("Goat Hill Pizza");
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
            defaultMutableTreeNode3 = new DefaultMutableTreeNode("Grocery Stores");
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            defaultMutableTreeNode4 = new DefaultMutableTreeNode("Good Life Grocery");
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
            defaultMutableTreeNode4 = new DefaultMutableTreeNode("Safeway");
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
            defaultMutableTreeNode2 = new DefaultMutableTreeNode("Noe Valley");
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            defaultMutableTreeNode3 = new DefaultMutableTreeNode("Restaurants");
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            defaultMutableTreeNode4 = new DefaultMutableTreeNode("Hamano Sushi");
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
            defaultMutableTreeNode4 = new DefaultMutableTreeNode("Hahn's Hibachi");
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
            defaultMutableTreeNode3 = new DefaultMutableTreeNode("Grocery Stores");
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            defaultMutableTreeNode4 = new DefaultMutableTreeNode("Real Foods");
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
            defaultMutableTreeNode4 = new DefaultMutableTreeNode("Bell Market");
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
            return defaultMutableTreeNode;
        }

        public Dimension getMinimumSize() {
            return this.minSize;
        }

        public Dimension getPreferredSize() {
            return this.minSize;
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            TreeExpandEventDemo2.this.saySomething("Tree-collapsed event detected", treeExpansionEvent);
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            TreeExpandEventDemo2.this.saySomething("Tree-expanded event detected", treeExpansionEvent);
        }

        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
            TreeExpandEventDemo2.this.saySomething("Tree-will-collapse event detected", treeExpansionEvent);
        }

        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            TreeExpandEventDemo2.this.saySomething("Tree-will-expand event detected", treeExpansionEvent);
            int n = JOptionPane.showOptionDialog(this, this.willExpandText, this.willExpandTitle, 0, 3, null, this.willExpandOptions, this.willExpandOptions[1]);
            if (n == 0) {
                TreeExpandEventDemo2.this.saySomething("Tree expansion cancelled", treeExpansionEvent);
                throw new ExpandVetoException(treeExpansionEvent);
            }
        }
    }
}

