/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ContainerEventDemo
extends JApplet
implements ContainerListener,
ActionListener {
    JTextArea display;
    JPanel buttonPanel;
    JButton addButton;
    JButton removeButton;
    JButton clearButton;
    Vector buttonList;
    static final String ADD = "add";
    static final String REMOVE = "remove";
    static final String CLEAR = "clear";
    static final String newline = "\n";

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == ADD) {
            JButton jButton = new JButton("JButton #" + (this.buttonList.size() + 1));
            this.buttonList.addElement(jButton);
            this.buttonPanel.add(jButton);
            this.buttonPanel.revalidate();
        } else if (string == REMOVE) {
            int n = this.buttonList.size() - 1;
            try {
                JButton jButton = (JButton)this.buttonList.elementAt(n);
                this.buttonPanel.remove(jButton);
                this.buttonList.removeElementAt(n);
                this.buttonPanel.revalidate();
                this.buttonPanel.repaint();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        } else if (string == CLEAR) {
            this.display.setText("");
        }
    }

    public void componentAdded(ContainerEvent containerEvent) {
        this.displayMessage(" added to ", containerEvent);
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        this.displayMessage(" removed from ", containerEvent);
    }

    void displayMessage(String string, ContainerEvent containerEvent) {
        this.display.append(String.valueOf(((JButton)containerEvent.getChild()).getText()) + " was" + string + containerEvent.getContainer().getClass().getName() + newline);
    }

    public void init() {
        this.buttonList = new Vector(10, 10);
        this.addButton = new JButton("Add a button");
        this.addButton.setActionCommand(ADD);
        this.addButton.addActionListener(this);
        this.removeButton = new JButton("Remove a button");
        this.removeButton.setActionCommand(REMOVE);
        this.removeButton.addActionListener(this);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setPreferredSize(new Dimension(200, 75));
        this.buttonPanel.addContainerListener(this);
        this.display = new JTextArea();
        this.display.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.display);
        jScrollPane.setPreferredSize(new Dimension(200, 75));
        this.clearButton = new JButton("Clear text area");
        this.clearButton.setActionCommand(CLEAR);
        this.clearButton.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.clearButton, gridBagConstraints);
        jPanel.add(this.clearButton);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.addButton, gridBagConstraints);
        jPanel.add(this.addButton);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.removeButton, gridBagConstraints);
        jPanel.add(this.removeButton);
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.buttonPanel, gridBagConstraints);
        jPanel.add(this.buttonPanel);
        this.setContentPane(jPanel);
    }
}

