/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SoundExample
extends JApplet
implements ActionListener {
    private SoundList soundList;
    private String onceFile = "bark.au";
    private String loopFile = "train.au";
    private AudioClip onceClip;
    private AudioClip loopClip;
    private static String PLAY_ONCE_CMD = "playOnce";
    private static String START_LOOP_CMD = "startLoop";
    private static String STOP_LOOP_CMD = "stopLoop";
    private static String RELOAD_CMD = "reload";
    private JButton playOnce;
    private JButton startLoop;
    private JButton stopLoop;
    private JButton reload;
    private boolean looping = false;

    public void init() {
        try {
            SwingUtilities.invokeAndWait((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception exception) {
            System.err.println("createGUI didn't successfully complete");
        }
    }

    private void createGUI() {
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.setContentPane(jPanel);
        this.playOnce = new JButton("Bark!");
        this.playOnce.setActionCommand(PLAY_ONCE_CMD);
        this.playOnce.addActionListener(this);
        this.add(this.playOnce);
        this.startLoop = new JButton("Start sound loop");
        this.startLoop.setActionCommand(START_LOOP_CMD);
        this.stopLoop = new JButton("Stop sound loop");
        this.stopLoop.setActionCommand(STOP_LOOP_CMD);
        this.stopLoop.setEnabled(false);
        this.startLoop.addActionListener(this);
        this.add(this.startLoop);
        this.stopLoop.addActionListener(this);
        this.add(this.stopLoop);
        this.reload = new JButton("Reload sounds");
        this.reload.setActionCommand(RELOAD_CMD);
        this.reload.addActionListener(this);
        this.add(this.reload);
        this.startLoadingSounds();
    }

    void startLoadingSounds() {
        this.soundList = new SoundList((Applet)this, this.getCodeBase());
        this.soundList.startLoading(this.loopFile);
        this.soundList.startLoading(this.onceFile);
    }

    public void stop() {
        if (this.onceClip != null) {
            this.onceClip.stop();
        }
        if (this.looping && this.loopClip != null) {
            this.loopClip.stop();
        }
    }

    public void start() {
        if (this.looping && this.loopClip != null) {
            this.loopClip.loop();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (PLAY_ONCE_CMD.equals(string)) {
            if (this.onceClip == null) {
                this.onceClip = this.soundList.getClip(this.onceFile);
            }
            if (this.onceClip != null) {
                this.onceClip.play();
                this.showStatus("Playing sound " + this.onceFile + ".");
            } else {
                this.showStatus("Sound " + this.onceFile + " not loaded yet.");
            }
            return;
        }
        if (START_LOOP_CMD.equals(string)) {
            if (this.loopClip == null) {
                this.loopClip = this.soundList.getClip(this.loopFile);
            }
            if (this.loopClip != null) {
                this.looping = true;
                this.loopClip.loop();
                this.stopLoop.setEnabled(true);
                this.startLoop.setEnabled(false);
                this.showStatus("Playing sound " + this.loopFile + " continuously.");
            } else {
                this.showStatus("Sound " + this.loopFile + " not loaded yet.");
            }
            return;
        }
        if (STOP_LOOP_CMD.equals(string)) {
            if (this.looping) {
                this.looping = false;
                this.loopClip.stop();
                this.startLoop.setEnabled(true);
                this.stopLoop.setEnabled(false);
            }
            this.showStatus("Stopped playing sound " + this.loopFile + ".");
            return;
        }
        if (RELOAD_CMD.equals(string)) {
            if (this.looping) {
                this.looping = false;
                this.loopClip.stop();
                this.startLoop.setEnabled(true);
                this.stopLoop.setEnabled(false);
            }
            this.loopClip = null;
            this.onceClip = null;
            this.startLoadingSounds();
            this.showStatus("Reloading all sounds.");
            return;
        }
    }

    public void destroy() {
        try {
            SwingUtilities.invokeAndWait((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception exception) {
            System.err.println("createGUI didn't successfully complete");
        }
    }

    private void destroyGUI() {
        this.looping = false;
        this.loopClip = null;
        this.onceClip = null;
        this.getContentPane().removeAll();
    }

    static /* synthetic */ void access$000(SoundExample soundExample) {
        soundExample.createGUI();
    }

    static /* synthetic */ void access$100(SoundExample soundExample) {
        soundExample.destroyGUI();
    }
}

