/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;

public class TumbleItem
extends JApplet
implements ActionListener {
    int loopslot = -1;
    String dir;
    Timer timer;
    int pause;
    int offset;
    int off;
    int speed;
    int nimgs;
    int width;
    Animator animator;
    ImageIcon[] imgs;
    int maxWidth;
    JLabel statusLabel;
    SwingWorker worker = new SwingWorker<ImageIcon[], Void>(){

        @Override
        public ImageIcon[] doInBackground() {
            ImageIcon[] imageIconArray = new ImageIcon[TumbleItem.this.nimgs];
            for (int i = 0; i < TumbleItem.this.nimgs; ++i) {
                imageIconArray[i] = TumbleItem.this.loadImage(i + 1);
            }
            return imageIconArray;
        }

        @Override
        public void done() {
            TumbleItem.this.animator.removeAll();
            TumbleItem.this.loopslot = -1;
            try {
                TumbleItem.this.imgs = (ImageIcon[])this.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                String string = null;
                Throwable throwable = executionException.getCause();
                string = throwable != null ? throwable.getMessage() : executionException.getMessage();
                System.err.println("Error retrieving file: " + string);
            }
        }
    };

    protected void loadAppletParameters() {
        String string = this.getParameter("img");
        this.dir = string != null ? string : "images/tumble";
        string = this.getParameter("pause");
        this.pause = string != null ? Integer.valueOf(string) : 1900;
        string = this.getParameter("offset");
        this.offset = string != null ? Integer.valueOf(string) : 0;
        string = this.getParameter("speed");
        this.speed = string != null ? 1000 / Integer.valueOf(string) : 100;
        string = this.getParameter("nimgs");
        this.nimgs = string != null ? Integer.valueOf(string) : 16;
        string = this.getParameter("maxwidth");
        this.maxWidth = string != null ? Integer.valueOf(string) : 0;
    }

    private void createGUI() {
        this.width = this.getSize().width;
        if (this.offset < 0) {
            this.off = this.width - this.maxWidth;
        }
        this.animator = new Animator();
        this.animator.setOpaque(true);
        this.animator.setBackground(Color.white);
        this.setContentPane(this.animator);
        this.statusLabel = new JLabel("Loading Images...", 0);
        this.animator.add((Component)this.statusLabel, "Center");
    }

    @Override
    public void init() {
        this.loadAppletParameters();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    TumbleItem.this.createGUI();
                }
            });
        }
        catch (Exception exception) {
            System.err.println("createGUI didn't successfully complete");
        }
        this.timer = new Timer(this.speed, this);
        this.timer.setInitialDelay(this.pause);
        this.timer.start();
        this.worker.execute();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.worker.isDone()) {
            return;
        }
        ++this.loopslot;
        if (this.loopslot >= this.nimgs) {
            this.loopslot = 0;
            this.off += this.offset;
            if (this.off < 0) {
                this.off = this.width - this.maxWidth;
            } else if (this.off + this.maxWidth > this.width) {
                this.off = 0;
            }
        }
        this.animator.repaint();
        if (this.loopslot == this.nimgs - 1) {
            this.timer.restart();
        }
    }

    @Override
    public void start() {
        if (this.worker.isDone() && this.nimgs > 1) {
            this.timer.restart();
        }
    }

    @Override
    public void stop() {
        this.timer.stop();
    }

    protected ImageIcon loadImage(int n) {
        String string = this.dir + "/T" + n + ".gif";
        int n2 = 2400;
        int n3 = 0;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getClass().getResourceAsStream(string));
        if (bufferedInputStream != null) {
            byte[] byArray = new byte[n2];
            try {
                n3 = bufferedInputStream.read(byArray);
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("Couldn't read stream from file: " + string);
                return null;
            }
            if (n3 <= 0) {
                System.err.println("Empty file: " + string);
                return null;
            }
            return new ImageIcon(Toolkit.getDefaultToolkit().createImage(byArray));
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }

    @Override
    public String getAppletInfo() {
        return "Title: TumbleItem v1.2, 23 Jul 1997\nAuthor: James Gosling\nA simple Item class to play an image loop.";
    }

    @Override
    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"img", "string", "the directory containing the images to loop"}, {"pause", "int", "pause between complete loops; default is 3900"}, {"offset", "int", "offset of each image to simulate left (-) or right (+) motion; default is 0 (no motion)"}, {"speed", "int", "the speed at which the frames are looped; default is 100"}, {"nimgs", "int", "the number of images to be looped; default is 16"}, {"maxwidth", "int", "the maximum width of any image in the loop; default is 0"}};
        return stringArray;
    }

    public class Animator
    extends JPanel {
        public Animator() {
            super(new BorderLayout());
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (TumbleItem.this.worker.isDone() && TumbleItem.this.loopslot > -1 && TumbleItem.this.loopslot < TumbleItem.this.nimgs && TumbleItem.this.imgs != null && TumbleItem.this.imgs[TumbleItem.this.loopslot] != null) {
                TumbleItem.this.imgs[TumbleItem.this.loopslot].paintIcon(this, graphics, TumbleItem.this.off, 0);
            }
        }
    }
}

