/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class TabbedPaneController {
    JPanel tabbedPanel = null;
    JTabbedPane tabbedPane;
    JPanel emptyFilePanel = null;
    JTextArea emptyFileArea = null;
    FileAndTextTransferHandler transferHandler;
    boolean noFiles = true;
    String fileSeparator;

    public TabbedPaneController(JTabbedPane jTabbedPane, JPanel jPanel) {
        this.tabbedPane = jTabbedPane;
        this.tabbedPanel = jPanel;
        this.transferHandler = new FileAndTextTransferHandler(this);
        this.fileSeparator = System.getProperty("file.separator");
        if ("\\".equals(this.fileSeparator)) {
            this.fileSeparator = "\\\\";
        }
        this.init();
    }

    public JTextArea addTab(String string) {
        if (this.noFiles) {
            this.tabbedPanel.remove(this.emptyFilePanel);
            this.tabbedPanel.add((Component)this.tabbedPane, "Center");
            this.noFiles = false;
        }
        String[] stringArray = string.split(this.fileSeparator);
        return this.makeTextPanel(stringArray[stringArray.length - 1], string);
    }

    public void clearAll() {
        if (!this.noFiles) {
            this.tabbedPane.removeAll();
            this.tabbedPanel.remove(this.tabbedPane);
        }
        this.init();
    }

    private void init() {
        String string = "Select one or more files from the file chooser and drop here...";
        this.noFiles = true;
        if (this.emptyFilePanel == null) {
            this.emptyFileArea = new JTextArea(20, 15);
            this.emptyFileArea.setEditable(false);
            this.emptyFileArea.setDragEnabled(true);
            this.emptyFileArea.setTransferHandler(this.transferHandler);
            this.emptyFileArea.setMargin(new Insets(5, 5, 5, 5));
            JScrollPane jScrollPane = new JScrollPane(this.emptyFileArea);
            this.emptyFilePanel = new JPanel(new BorderLayout(), false);
            this.emptyFilePanel.add((Component)jScrollPane, "Center");
        }
        this.tabbedPanel.add((Component)this.emptyFilePanel, "Center");
        this.tabbedPanel.repaint();
        this.emptyFileArea.setText(string);
    }

    protected JTextArea makeTextPanel(String string, String string2) {
        JTextArea jTextArea = new JTextArea(20, 15);
        jTextArea.setDragEnabled(true);
        jTextArea.setTransferHandler(this.transferHandler);
        jTextArea.setMargin(new Insets(5, 5, 5, 5));
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        this.tabbedPane.addTab(string, null, jScrollPane, string2);
        this.tabbedPane.setSelectedComponent(jScrollPane);
        return jTextArea;
    }
}

