/*
 * This code is stolen from the public-domain package slnr (currently
 * maintained by myself), and originally from Philippe Goujard
 * (Philippe.Goujard@UK.Sun.COM).
 */

#include <string.h>
#include <stdio.h>
#include "colour.h"


/*
** The idea of a color_string array is to allow several scr() call in
** one printf.
** If we don't do that printf only see the last scr() since they all
** have the same address.
*/
char Color_string[MAX_CLR][12];
int Color_no = 0;

/*
** Generates a string with ansi colors
** The unix version checks the environment variable TERM
*/
char *scr(int attribute,int foreground, int background)
{
	char att_str[20],for_str[20],back_str[20];
	int n = Color_no;

	att_str[0] = '\0';
	for_str[0] = '\0';
	back_str[0] = '\0';
	if (attribute != NONE)
	{
		sprintf (att_str,"%d",attribute);
		if (foreground != NONE || background != NONE)
			strcat(att_str,";");
	}
	if (foreground != NONE)
	{
		sprintf (for_str,"%d",30+foreground);
		if (background != NONE)
			strcat(for_str,";");
	}
	if (background != NONE)
		sprintf (back_str,"%d",40+background);
	sprintf (Color_string[n],"%s%s%s%sm",COL_HEAD,att_str,
		for_str,back_str);
	Color_no++;
	Color_no = Color_no%MAX_CLR;
	return (Color_string[n]);
}

void cls(void)
{
		printf("\033[0;37;40m\033[2J\033[H");
		fflush(stdout);
}
