/* libai/ai_move.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include "ai.h"
#include "ai_err.h"  /* aka internal.h */
#include <assert.h>

/*
 * This function will return the move that an ai player wants to
 * make...  The set_t it returns is statically allocated...  Beware!
 * Be careful about passing the set that I should lay ontop of.  You
 * should call ass_a_clear() before extracting the currently-laid
 * set (this is so that if the set is NAC, I am aware of this).
 *
 * NOTE that it is a big error to call this function without having
 * any cards...
 */
set_t
ai_move (
 	ai_t ai,
 	const hand_t hand,  /* My hand... */
 	const set_t set  /* What set I have to lay on */
) {
 	int i;
 	set_t ret;  /* Should do static here, and pointer in children */

 	/* Make sure we have at least one card... */
 	for (i=0; i<14; i++) if (hand->cards[i] != NAC) break;
 	ai_err (i == 14, "libai: ai_move(): You have no cards\n");

 	/* Probably other checks we can do... */

 	switch (ai->l) {
 	case SIMPLE:
 		ret = ai_m_smpnl (ai, hand, set);
 		ai->pgone++;
 		if (ret->card != NAC) ai->cleft[ai->whoami] -= ret->num;
 		return ret;
 	case NOLAY:
 		ret = ai_m_smpnl (ai, hand, set);
 		ai->pgone++;
 		if (ret->card != NAC) ai->cleft[ai->whoami] -= ret->num;
 		return ret;
 	case RAND:
 		ret = ai_m_rand (ai, hand, set);
 		ai->pgone++;
 		if (ret->card != NAC) ai->cleft[ai->whoami] -= ret->num;
 		return ret;
 	default:
 		assert (0);
 		/*^^^^^^^*/

 		ret = ai_m_rand (ai, hand, set);
 		ai->pgone++;
 		if (ret->card != NAC) ai->cleft[ai->whoami] -= ret->num;
 		return ret;
 	}
}
