/* libai/ai_notify.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include "ai.h"

/*
NOTE  ...  Umm...  We should also be telling this function
what cards the AI got given, and what cards it gave away...
This is very useful information...
*/

/*
 * Call this function everytime after dealing.  The ai library will
 * assume that the players PREZ and VICE each have 14 cards, while the
 * the ASS and VICEASS each have 13 cards.  If everyone is an ASS, it
 * assumes that a and b each have 14 cards.
 */
void
ai_notify (
 	ai_t ai,
 	position_t a,
 	position_t b,
 	position_t c,
 	position_t d
) {
 	int i, ii;  /* junk */

 	ai->ps[0] = a;
 	ai->ps[1] = b;
 	ai->ps[2] = c;
 	ai->ps[3] = d;

 	/* We haven't seen any cards... */
 	for (i=0; i<4; i++) for (ii=0; ii<14; ii++) ai->seen[i].cards[ii] = NAC;
 	ai->pgone = 0;

 	for (i=0; i<4; i++) ai->cleft[i] = 13;
 	/* But the PREZ and VICE have 14 cleft... */
 	if (a == VICE || a == PREZ) ai->cleft[0] = 14;
 	if (b == VICE || b == PREZ) ai->cleft[1] = 14;
 	if (c == VICE || c == PREZ) ai->cleft[2] = 14;
 	if (c == VICE || c == PREZ) ai->cleft[3] = 14;

 	if (a == ASS && b == ASS) {
 		/* everyone must be an ass */
 		ai->cleft[0] = 14;
 		ai->cleft[1] = 14;
 	}
}
