/* libass/ass_GameDown.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#define ASS_NODEFS
#include "ass.h"
#include "ass_err.h"

/*
 * This function will return the set that is currently waiting to
 * be laid on.  If there is not set waiting to be laid on, then the
 * set returned is made of NAC cards.
 */
set_t
ass_GameDown (
 	game_t game  /* The game */
) {
 	ass_err (!game, "libass: ass_GameDown(): null game\n");

 	return &(game->down);
}
