/* libass/ass_deal.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include "../rand/rand.h"
#include <assert.h>
#include <stdlib.h>
#include "ass.h"

static int comp (const void *, const void *);  /* Sort a hand nicely */
static void deal_all_ass (game_t);  /* deal to a bunch of asses */
static void deal_norm (game_t);  /* deal normally */

/*
 * This will deal the cards out.  If there is already a game in progress
 * with the given game_t, it will be dealt away, and a new round will
 * begin.
 */
void
ass_deal (
 	game_t game  /* The game whose cards are to be dealt */
) {
 	int i;  /* junk */

 	ass_a_shuffle (game);  /* Move winner to PREZ, etc. */

 	for (i=0; i<4; i++) if (game->ppl[i].pos != ASS) break;
 	assert (i==0 || i == 1 || i == 4);  /* Either everyone's an ASS, or
 	                                     * only one person's an ASS */
 	if (i == 4) deal_all_ass (game); else deal_norm (game);

 	/* Sort each hand... */
 	for (i=0; i<4; i++) qsort (game->ppl[i].hand.cards, 14, sizeof(card_t),
 	                           comp);

 	game->down.card = NAC;  /* No cards down */
 	game->down.num = 0;     /* Inconsequential */
 	game->start = -1;  /* No one has started... */
 	game->cur = -1;  /* No one just took their turn */
 	game->last = -1;  /* No one laid any last set... */
 	for (i=0; i<4; i++) game->ppl[i].out = 0;
}

/*
 * The comparison function for qsort().  Hmm...  I hope the fact that
 * it cards of equal value are not equal doesn't confuse qsort()...  :)
 */
static int
comp (
 	const void * first,  /* The first item to compare */
 	const void * second  /* The second item to compare */
) {
 	if (*(const card_t *) first >= *(const card_t *) second) return 1;
 	return -1;
}

/*
 * This will do the dealing when everybody is an ASS
 */
static void
deal_all_ass (
 	game_t game
) {
 	int cg[14];  /* Cards-Given-out */
 	int i, ii;

 	for (i=0; i<14; i++) cg[i] = 0;  /* clear cg[] */

 	for (i=0; i<4; i++) for (ii=0; ii<14; ii++) {
 		int x;  /* What card are we trying to give away? */

 		/* Oooh.  Yuck.  First two players get 14 cards, last two
 		 * 13 cards.  We really should do this more neatly...  :( */
 		if (i==2 && ii==13) break;
 		if (i==3 && ii==13) break;
trycard:
 		x = (myrand() % 14);
 		cg[x]++;
/* Hmm...  Would it be better to just forgoe this idea of watching for really
 * shitty random()'s altogether?  Hmm...  Probably...  :)  Ohwell...  :) */
 		assert (cg[x] >= 0);  /* abort() if random() is really shitty */

 		if (cg[x] >= 5) goto trycard;  /* already given out 4 of x */
 		if (x + 1 == JOKER && cg[x] >= 3) goto trycard;  /* 2 JOKERS */

 		game->ppl[i].hand.cards[ii] = x + 1;  /* +1 to bypass NAC */
 	}
}

/* Dealing starts with the VICE so that the VICE and PREZ get the two
 * extra cards that exist... */
#define PL(a) ((a) == 0 ? VICE : \
               (a) == 1 ? PREZ : \
               (a) == 2 ? ASS : \
               (a) == 3 ? VICEASS : \
               (assert (0), ASS))

/*
 * This will do the dealing when there is one person per position
 */
static void
deal_norm (
 	game_t game
) {
 	int cg[14];  /* Cards-Given-out */
 	int i, ii, z;
 	position_t j;

 	for (i=0; i<14; i++) cg[i] = 0;  /* clear cg[] */

 	for (i=0; i<4; i++) for (ii=0; ii<14; ii++) {
 		int x;  /* What card are we trying to give away? */

 		j = PL (i);  /* What position are we looking for? */

 		/* Oooh.  Yuck.  First two players get 14 cards, last two
 		 * 13 cards.  We really should do this more neatly...  :( */
 		if (i==2 && ii==13) break;
 		if (i==3 && ii==13) break;

 		for (z=0; z<4; z++) if (game->ppl[z].pos == j) break;
 		if (z == 4) assert (0);  /* MISSING A POSITION! */
trycard:
 		x = (myrand() % 14);
 		cg[x]++;
/* Hmm...  Would it be better to just forgoe this idea of watching for really
 * shitty random()'s altogether?  Hmm...  Probably...  :)  Ohwell...  :) */
 		assert (cg[x] >= 0);  /* abort() if random() is really shitty */

 		if (cg[x] >= 5) goto trycard;  /* already given out 4 of x */
 		if (x + 1 == JOKER && cg[x] >= 3) goto trycard;  /* 2 JOKERS */

 		game->ppl[z].hand.cards[ii] = x + 1;  /* +1 to bypass NAC */
 	}
}
