/* libass/ass_init.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include <stdlib.h>
#include <string.h>
#include "ass.h"
#include "ass_err.h"

/*
 * This function will initialize a game_t for future use.  You must have
 * previously allocated *game, with a line such as
 *
 * game = malloc (sizeof (*game));
 *
 * You will still have to call the ass_deal() function before you can
 * begin making moves.
 */
void
ass_init (
 	game_t game  /* must be malloc()'d already */
) {
 	int i, ii;  /* junk */

 	ass_err (!game, "libass: ass_init(): null game\n");

 	game->cur = -1;  /* No one just took their turn... */
 	game->last = -1;  /* No one just laid a set... */
 	game->down.card = NAC;  /* no cards currently laid */
 	game->down.num = 0;     /* Inconsequential */
 	game->start = -2;  /* This can be used in ass_assert() calls to
 	                    * make-sure that they are being passed valid
 	                    * games...  ie. ones that have been ass_deal()'d.
 	                    * Could theoretically add similar things for
 	                    * person_t, hand_t, etc...  */
 	for (i=0; i<4; i++) game->ppl[i].out = 0;
 
 	for (i=0; i<4; i++) {
 		game->ppl[i].pos = ASS;  /* Everyone in the same position */
 		for (ii=0; ii<54; ii++)
 			game->ppl[i].hand.cards[ii] = NAC; /* Clear all cards */
 	}
}
