/* libass/ass_setlt.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include "ass.h"

/*
 * This simple function will test to see wether one of two sets
 * can be placed on the other.  It will return TRUE if the first set
 * is less than the second, or FALSE otherwise.
 */
int
ass_setlt (
 	set_t a,  /* Is this set less-than */
 	set_t b   /* this set? */
) {
 	/* Special case so that the person is allowed to pass...  Normally
 	 * one is not permitted to lay a NAC on anything... :) */
 	if (b->card == NAC) return 1;

 	/* Special case where a->card == NAC so that a->num doesn't count */
 	if (a->card == NAC) return 1;

 	/* The number of cards must be the same (special cases to be
 	 * excepted) */
 	if (a->num != b->num) {
 		switch (b->card) {
 		case TWO:
 			/* May never lay a TWO on a JOKER or a TWO */
 			if (a->card == JOKER || a->card == TWO) return 0;

 			/* May not lay more TWOs than what are already down */
 			/* This is because it is conceivable that someone
 			 * will want to lay a joker on the person's TWO,
 			 * but without this little check, they may not have
 			 * that opportunity.  We don't do this check for
 			 * the JOKER since no one's gonna lay nothin' on
 			 * a JOKER, so it'd be pointless. */
 			if (b->num > a->num) return 0;

 			/* Unless b->card == TWO and the difference in # of
 			 * cards is only one... */
 			if ((a->num - (b->num * 2)) <= 0) return 1;
 			return 0;
 		case JOKER:
 			/* Or unless b->card == JOKER and the difference in
 			 * cards is less than 3 */
 			if (a->card != TWO && (a->num - (b->num * 3)) <= 0)
 				return 1;
 			if (a->card == TWO && (a->num * 2 - b->num * 3) <= 0)
 				return 1;
 			return 0;
 		default:
 			return 0;  /* The set comparison is arguably invalid in 
 			            * this case...  I don't think so...  :) */
 		}
 	}

 	/* The card value of a must be less than that of b */
 	if (!(a->card < b->card)) return 0;

 	return 1;
}
