/* libass/ass_sort.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include "ass.h"
#include <stdlib.h>

static int comp (const void *, const void *);

/*
 * Sort the hand.  Move NACs to the end.  Lowest cards to the front.
 */
void
ass_sort (
 	hand_t hand /* Sort what hand? */
) {
 	qsort (hand->cards, 14, sizeof(card_t), comp);
}

/*
 * qsort()'s comparison function.
 */
static int
comp (
 	const void * first,  /* item #1 */
 	const void * second  /* item #2 */
) {
 	/* NAC's a higher than everything else, since they are listed last */
 	if (*(const card_t *) first == NAC) return 1;
 	if (*(const card_t *) second == NAC) return -1;

 	if (*(const card_t *) first >= *(const card_t *) second) return 1;
 	return -1;
}
