/* libass/ass_turn.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include "ass.h"
#include <assert.h>

static int ass_ppl (game_t);

/*
 * This function will return a number (1-4) corresponding to whose
 * turn it is next.  It will return 0 if it is time to call ass_deal().
 */
int
ass_turn (
 	game_t game  /* in which game? */
) {
 	int i, ii, j, k, sillyflag=1;  /* junk */
 	int hack;

 	hack = game->cur;  /* I'm not sure that I really want this.
 	                    * I'm suspecting that I actually want game->cur
 	                    * to advance over empty people, but it doesn't
 	                    * even do that consistently, when it exits due
 	                    * (k==5)... */

 	/* First, let's make sure there is at least one player with cards
 	 * left who can take a turn... */
 	for (i=0; i<4; i++) for (j=0; j<14; j++)
 		if (game->ppl[i].hand.cards[j] != NAC) goto falsebreak;
falsebreak:
 	if (i == 4 && j == 14) return 0;  /* No cards left!! */

 	/* We'll call ass_ppl(), and if the person it returns doesn't
 	 * have any cards, we'll make it look like this person took their
 	 * turn, call ass_ppl() again, and so on. */
 	k=0;
nextguy:
 	i = ass_ppl (game);

 	for (j=0; j<14; j++)
 		if (game->ppl[i].hand.cards[j] != NAC) break;
 	/* If the person has no cards, try next person */
 	if (j == 14) {
 		k++;
 		if (k == 5) {
 			position_t z;
 			/* Okay, we're not having any luck finding the
 			 * next guy.  This must mean that the last person
 			 * to lay down a set no longer has any cards...  We'll
 			 * just look from them onwards to the next person
 			 * with cards. */
 			z = game->ppl[game->last].pos;
smplnextguy:
 			if (z == PREZ) z = ASS; else z++;

 			for (i=0; i<4; i++) if (game->ppl[i].pos == z) break;
 			if (i == 4) {
 				/* What!  There is no one with position z!
 				 * This may only happen when everyone is an
 				 * ASS! */
 				assert (z == VICEASS);  /* all ASSes */
 				z = ASS;  /* to fall back here, again */
 
 				/* When the next player can't be chosen
 				 * based on their position in the game, they
 				 * are chosen based on their index into ppl[] */
 				if (sillyflag) ii = game->last;
 				sillyflag = 0;

 				if (ii == 3) ii = 0; else ii++;
 			} else {
 				ii = i;
 			}

 			/* Okay, maybe this person has cards.  If not, then
 			 * we'll have to advance to the next person, again... */
 			for (j=0; j<14; j++)
 				if (game->ppl[ii].hand.cards[j] != NAC) break;
 			if (j != 14)
 				return game->cur = hack, ii + 1;
 			goto smplnextguy;
 		}
 		game->cur = i;  /* Simulate turn-taking for ass_ppl()'s sake */
 		goto nextguy;
 	}
 	return game->cur = hack, i + 1;  /* The person has cards! */
}


/*
 * This function will return a number (0-3) indicating whose turn it is.
 * It does not take into account that people without any cards do not
 * have any turns...
 */
static int  /* Whose turn is it?  (0-3) */
ass_ppl (
 	game_t game  /* In which game? */
) {
 	int i;  /* junk */
 	position_t j; /* junk */

 	/* If it's a new round, return an ASS */
 	if (game->start == -1) {
 		for (i=0; i<4; i++)  /* find first ASS */
 			if (game->ppl[i].pos == ASS) break;
 		assert (i != 4);  /* What!?  No ASSes!?  DIE!  DIE!  DIE! */
 		return i;
 	}

 	/* Otherwise, find the person who is after game->ppl[game->cur] */
 	j = game->ppl[game->cur].pos;
 	if (j == PREZ) j = ASS; else j++;
 	for (i=0; i<4; i++)
 		if (game->ppl[i].pos == j) break;

 	/* If we couldn't find any person with the next position, then
 	 * that means that some positions were duplicated in ppl[].  This
 	 * is allowed only under specific conditions. */
 	if (i == 4) {
 		assert (j == VICEASS);  /* Everyone should be ASS */

 		i = game->cur;
 		if (i == 3) i = 0; else i++;
 	}

 	/* If this person (i) is the one who started, we've wrapped since
 	 * everyone has gone.  Thus we should return the last person to
 	 * lay a set. */
 	if (i == game->start) return game->last;
 	return i;
}
