#ifndef __MY_TCL_H
#define __MY_TCL_H

#ifndef USE_SYS_TCL_H

#define TCL_OK 0
#define TCL_ERROR 1

typedef void * ClientData;
typedef struct Tcl_Interp {
	char * result;
	void (* freeProc) (char *);
	int errorLine;
} Tcl_Interp;

typedef struct Tcl_CmdInfo {
	void * proc;             /* Actually a pointer to a function */
	ClientData clientData;
	void * deleteProc;       /* Actually a pointer to a function */
	ClientData deleteData;
} Tcl_CmdInfo;

typedef char * (Tcl_VarTraceProc) (ClientData, Tcl_Interp *, char *, char *, int);

int Tcl_Init (Tcl_Interp *);
struct Tcl_Command_ * Tcl_CreateCommand (Tcl_Interp *, const char *,
	int (*) (ClientData, Tcl_Interp *, int, char **), ClientData,
	void (*) (ClientData));
int Tcl_PkgProvide (Tcl_Interp *, const char *, const char *);
void Tcl_SetResult (Tcl_Interp *, const char *, void (*) (char *));
void Tcl_Preserve (ClientData);
void Tcl_Release (ClientData);
int Tcl_GlobalEval (Tcl_Interp *, char *);
void Tcl_UntraceVar (Tcl_Interp *, char *, int, Tcl_VarTraceProc *, ClientData);
int Tcl_TraceVar (Tcl_Interp *, char *, int, Tcl_VarTraceProc *, ClientData);
int Tcl_GetCommandInfo (Tcl_Interp *, const char *, Tcl_CmdInfo *);

#define TCL_VOLATILE (void (*) (char *)) 1
#define TCL_STATIC (void (*) (char *)) 0

#define TCL_GLOBAL_ONLY 1
#define TCL_TRACE_WRITES 0x20

#else

#include <tcl.h>

#endif

#endif /* __MY_TCL_H */
