/* xprez/xp_all.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include "tcl.h"
#include <stdio.h>
#include <ass.h>
#include "internal.h"

/*
 * This is just the wrapper for ass_all()...
 *
 * xp_all
 *
 * Returns 1 if everyone's had their turn, 0 otherwise.
 */
int
xp_all (ClientData cdata, Tcl_Interp * interp, int argc, char ** argv) {
	char ret[200];

	if (argc != 1) {
		sprintf (ret, "Wrong # args: \"%s\"", argv[0]);
		Tcl_SetResult (interp, ret, TCL_VOLATILE);
		return TCL_ERROR;
	}

	if (ass_all (&SGBg))
		sprintf (ret, "1");
	else
		sprintf (ret, "0");
	Tcl_SetResult (interp, ret, TCL_VOLATILE);
	return TCL_OK;
}
