/* xprez/xp_call
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include "tcl.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

static char * xp_call_me (ClientData, Tcl_Interp *, char *, char *, int);

struct xp_xpcall {
	char * command;
	Tcl_Interp * interp;
	char * junk;
};

/* This is just evil */
int
xp_call (ClientData cdata, Tcl_Interp * interp, int argc, char ** argv) {
	char ret[50];
	struct xp_xpcall * x;

	x = malloc (sizeof (struct xp_xpcall));
	x->command = malloc (strlen (argv[2]) + 1);
	x->junk = malloc (strlen (argv[1]) + 1);
	x->interp = interp;
	strcpy (x->command, argv[2]);
	strcpy (x->junk, argv[1]);

	Tcl_TraceVar (x->interp, argv[1],
	    TCL_GLOBAL_ONLY|TCL_TRACE_WRITES, xp_call_me, x);

	return TCL_OK;
}

/* Satan spawn */
static char *
xp_call_me (ClientData cdata, Tcl_Interp * interp, char * n1, char * n2, int f){
	struct xp_xpcall * x;
	void * res, * fp;

	x = cdata;

	Tcl_Preserve ((ClientData) interp);

	fp = interp->freeProc;
	res = interp->result;
	if (Tcl_GlobalEval(interp, x->command) != TCL_OK) {
		printf ("XP_CALL error: %s\n", interp->result);
		interp->freeProc = fp;
		interp->result = res;
		Tcl_Release ((ClientData) interp);
		return NULL;  /* this should be an error... */
	}
	interp->freeProc = fp;
	interp->result = res;
	Tcl_Release ((ClientData) interp);

	Tcl_UntraceVar (x->interp, x->junk,
		TCL_GLOBAL_ONLY|TCL_TRACE_WRITES, xp_call_me, cdata);

	free (x->command);
	free (x->junk);

	return NULL;
}
