/* xprez/configure.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include "tcl.h"
#include <ass.h>
#include <ai.h>
#include "internal.h"
#include <string.h>
#include <stdio.h>

/*
 * Configure the behind-the-tcl-seens stuff.  Mostly the AI junk...
 * After doing this, you can actually start playing, and whatnot...
 * The only other way to permit youself to start playing and whatnot
 * is to call xp_load.
 *
 * xp_configure AITYPE AITYPE AITYPE
 *
 * Where AITYPE is one of
 * 	RAND
 * 	SIMPLE
 * 	NOLAY
 */
int
xp_configure (ClientData cdata, Tcl_Interp * interp, int argc, char ** argv) {
	int i, ii;

	if (argc != 4) {
		char s[500];
		sprintf (s,
		    "wrong # args: should be \"%s AITYPE AITYPE AITYPE\"",
		    argv[0]);
		Tcl_SetResult (interp, s, TCL_VOLATILE);
		return TCL_ERROR;
	}

	ass_init (&SGBg);

	for (i=1; i<=3; i++)
	  if (!strcasecmp (argv[i], "RAND")) {
	  	ai_init (&SGBai[i-1], i+1, RAND);
	  } else if (!strcasecmp (argv[i], "SIMPLE")) {
	  	ai_init (&SGBai[i-1], i+1, SIMPLE);
	  } else if (!strcasecmp (argv[i], "NOLAY")) {
	  	ai_init (&SGBai[i-1], i+1, NOLAY);
	  } else {
	  	char s[500];
	  	sprintf (s,
	  	    "AITYPE must be one of \"RAND\", \"SIMPLE\", or \"NOLAY\"");
	  	Tcl_SetResult (interp, s, TCL_VOLATILE);
	  	return TCL_ERROR;
	  }

	for (i=0; i<4; i++) SGBlaid[i] = NAC;
	for (i=0; i<4; i++) SGBldown[i] = 0;
	for (i=0; i<4; i++) SGBlnum[i] = 0;
	SGBlast = 0;
	for (i=0; i<4; i++) for (ii=0; ii<4; ii++) SGBscores[i][ii] = 0;

	Tcl_SetResult (interp, "", TCL_STATIC);
	return TCL_OK;
}
