/* xprez/xp_deal.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include "tcl.h"
#include <ass.h>
#include <ai.h>
#include <stdio.h>
#include "internal.h"

static const char * cname (card_t);

/*
 * This will deal the cards.
 * 
 * xp_deal
 *
 * returns something along the lines of
 *
 * You lost a two and a king, and you received a four and a four.
 *
 * It will return an empty string if no cards are switched.
 */
int
xp_deal (ClientData clientdata, Tcl_Interp * interp, int argc, char ** argv) {
	char ret[200];
	int i;
	hand_t ss;

	ass_deal (&SGBg);

	/* Increment the scores appropriately, but don't do it if
	 * this is the first time we've dealt (ie. if everyone's an ASS) */
	if (SGBg.ppl[0].pos != SGBg.ppl[1].pos) {
		SGBscores[0][SGBg.ppl[0].pos - ASS]++;
		SGBscores[1][SGBg.ppl[1].pos - ASS]++;
		SGBscores[2][SGBg.ppl[2].pos - ASS]++;
		SGBscores[3][SGBg.ppl[3].pos - ASS]++;
	}

	ss = ass_switch (&SGBg);
	*ret = '\0';
	/* if (not everyone is an ass) then */
	if (SGBg.ppl[0].pos != SGBg.ppl[1].pos) switch (SGBg.ppl[0].pos) {
	case ASS:
		sprintf (ret,
		    "You lost your %s and %s, but recieved a %s and a %s.",
		    cname(ss->cards[0]), cname(ss->cards[1]),
		    cname(ss->cards[2]), cname(ss->cards[3]));
		break;
	case VICEASS:
		sprintf (ret,
		    "You no longer have your %s; instead you have a %s.",
		    cname(ss->cards[4]), cname(ss->cards[5]));
		break;
	case VICE:
		sprintf (ret,
		    "You've gotten rid of your %s, and have taken a %s.",
		    cname(ss->cards[5]), cname(ss->cards[4]));
		break;
	case PREZ:
		sprintf (ret,
		    "You got rid of your %s and %s, "
		    "and appropriated a %s and a %s.",
		    cname(ss->cards[2]), cname(ss->cards[3]),
		    cname(ss->cards[0]), cname(ss->cards[1]));
		break;
	}

	ai_notify (&SGBai[0], SGBg.ppl[0].pos, SGBg.ppl[1].pos,
	    SGBg.ppl[2].pos, SGBg.ppl[3].pos);
	ai_notify (&SGBai[1], SGBg.ppl[0].pos, SGBg.ppl[1].pos,
	    SGBg.ppl[2].pos, SGBg.ppl[3].pos);
	ai_notify (&SGBai[2], SGBg.ppl[0].pos, SGBg.ppl[1].pos,
	    SGBg.ppl[2].pos, SGBg.ppl[3].pos);

	for (i=0; i<4; i++) SGBlaid[i] = NAC;
	for (i=0; i<4; i++) SGBldown[i] = 0;
	for (i=0; i<4; i++) SGBlnum[i] = 0;
	SGBlast = 0;

	Tcl_SetResult (interp, ret, TCL_STATIC);
	return TCL_OK;
}

static const char *
cname (card_t c) {
	switch (c) {
	case ACE:
		return "Ace";
	case TWO:
		return "two";
	case THREE:
		return "three";
	case FOUR:
		return "four";
	case FIVE:
		return "five";
	case SIX:
		return "six";
	case SEVEN:
		return "seven";
	case EIGHT:
		return "eight";
	case NINE:
		return "nine";
	case TEN:
		return "ten";
	case JACK:
		return "Jack";
	case QUEEN:
		return "Queen";
	case KING:
		return "King";
	case JOKER:
		return "Joker";
	case NAC:
		return "ERROR in xprez/xp_deal.c";
	default:
		return "YOU ARE FUCKED in xprez/xpdeal.c";
	}
}
