/* xprez/xp_lay.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include <ass.h>
#include <ai.h>
#include "tcl.h"
#include "internal.h"
#include <stdlib.h>
#include <stdio.h>

/*
 * This will lay a set made of the first card in the list that you
 * pass it.  The number of cards in the set will be determined by the
 * number of spaces in the single variable that lists cards that you
 * pass this function.
 *
 * xp_lay CARD NUM
 *
 * Where CARD (0-13) indexes one of the cards you want to lay,
 * and where NUM (0-4) is the number of cards you want to lay.  A NUM of 0
 * will PASS, regardless of what the CARD is.
 *
 * Returns, 1 == failure, 0 == success
 */
int
xp_lay (ClientData cdata, Tcl_Interp * interp, int argc, char ** argv) {
	struct set_s set;
	char ret[200];
	int i, ii;  /* junk */

/* Beware!  This puppy assumes all the args passed to it
 * are correct!! */

	set.card = SGBg.ppl[0].hand.cards[atoi(argv[1])];
	set.num = atoi(argv[2]);
	if (set.num == 0) {
		/* Special-case the pass move */
		set.card = NAC;
		set.num = 1;
	}

	if (ass_turn (&SGBg) != 1) {
		sprintf (ret, "It's not your turn to move!");
		Tcl_SetResult (interp, ret, TCL_VOLATILE);
		return TCL_OK;  /* heh.  arguably an error */
	}

	if (SGBg.down.card == NAC && set.card == NAC) {
		sprintf (ret, "You can't pass now.  You must lay a set!");
		Tcl_SetResult (interp, ret, TCL_VOLATILE);
		return TCL_OK;
	}

	if (!ass_setlt (&SGBg.down, &set)) {
		sprintf (ret, "That set isn't high enough to lay!");
		Tcl_SetResult (interp, ret, TCL_VOLATILE);
		return TCL_OK;
	}

	if (ass_move (&SGBg, &set)) {
		sprintf (ret, "You can't make that move!");
		Tcl_SetResult (interp, ret, TCL_VOLATILE);
		return TCL_OK;
	}

	for (i=0; i < 3; i++)
		ai_watch (&SGBai[i], &set, 1);
	if (ass_a_clear (&SGBg)) {
		/* Clear the list of cards that are on the table */
		/* As a special case, do not clear the (shown) set if
		 * the current game is over.  This is so that the same
		 * thing happens at end-game when the human is the loser
		 * as when an AI is the loser.  When the AI is the last
		 * out, ass_turn() in xp_aimove.c will return 0 so it
		 * never clears the (shown) set. */
		if (ass_turn (&SGBg) != 0) {
			for (i=0; i<4; i++) SGBlaid[i] = NAC;
			for (i=0; i<4; i++) SGBldown[i] = 0;
			for (i=0; i<4; i++) SGBlnum[i] = 0;
			SGBlast = 0;
		} else {
			SGBlaid[SGBlast] = set.card;
			SGBldown[SGBlast] = 1;
			SGBlnum[SGBlast] = set.num;
			SGBlast++;
		}
	} else {
		SGBlaid[SGBlast] = set.card;
		SGBldown[SGBlast] = 1;
		SGBlnum[SGBlast] = set.num;
		SGBlast++;
	}

	*ret = '\0';
	Tcl_SetResult (interp, ret, TCL_VOLATILE);
	return TCL_OK;
}
