/* xprez/xp_left
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include "tcl.h"
#include <stdio.h>
#include <ass.h>
#include "internal.h"

/*
 * This returns the number of players left in the game who still have
 * cards left, eh...
 */
int
xp_left (ClientData cdata, Tcl_Interp * interp, int argc, char ** argv) {
	char ret[200];
	int left;
	int i, ii;

	if (argc != 1) {
		sprintf (ret, "Wrong # args: \"%s\"", argv[0]);
		Tcl_SetResult (interp, ret, TCL_VOLATILE);
		return TCL_ERROR;
	}

	left = 0;
	for (i=0; i<4; i++) {
		for (ii=0; ii<14; ii++)
			if (SGBg.ppl[i].hand.cards[ii] != NAC) break;
		if (ii != 14) left++;
	}

	sprintf (ret, "%d", left);
	Tcl_SetResult (interp, ret, TCL_VOLATILE);
	return TCL_OK;
}
