/* xprez/xp_turn.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include "tcl.h"
#include <ass.h>
#include <stdio.h>
#include "internal.h"

/*
 * This will return (0-4), the player whose turn it is, right now.
 * Beware that this will advance after xp_lay() and xp_aimove(), sometimes,
 * so you will often have to call this before those functions, store
 * the value, and then, if the functions succeed, do whatever it is
 * you wanted to do with the person who just took their turn.
 *
 * xp_turn
 *
 * Returns 0-4.  0 signifies that you must redeal the cards.
 */
int
xp_turn (ClientData cdata, Tcl_Interp * interp, int argc, char ** argv) {
	char ret[100];

	if (argc != 1) {
		sprintf (ret, "Wrong # args: \"%s\"", argv[0]);
		Tcl_SetResult (interp, ret, TCL_VOLATILE);
		return TCL_ERROR;
	}

	sprintf (ret, "%d", ass_turn (&SGBg));
	Tcl_SetResult (interp, ret, TCL_VOLATILE);
	return TCL_OK;
}
