#    Copyright (C) 1997  Timothy M. Vanderhoek
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#    Tim Vanderhoek
#    ac199@hwcn.org
#

# We import the configure proc from the file xprez-proc-configure...
# This substitution is done by make...
!XPREZ-PROC-CONFIGURE!

# About the program, in general...
# xprez		- Global configuration data
proc about {} {
	global xprez

	toplevel .about
	wm iconname .about "About TVP"
	wm title .about "All About TVP"
	frame .about.l

	text .about.l.text -relief raised -wrap word \
		-yscrollcommand ".about.l.sby set"
	.about.l.text insert 1.0 $xprez(abouttvp)

	button .about.done -text "Dismiss" -command "destroy .about"
	scrollbar .about.l.sby -command ".about.l.text yview"
	pack .about.done -side bottom
	pack .about.l -fill both -side top -expand true
	pack .about.l.sby -side left -fill y
	pack .about.l.text -side right -fill both -expand 1
}

# Show the license
# xprez		- Global configuration data
proc license {} {
	global xprez

	toplevel .license
	wm iconname .license "TVP License"
	wm title .license "GNU GPL License for Tim Vanderhoek's X-President"
	frame .license.l

	text .license.l.text -relief raised -wrap word \
		-yscrollcommand ".license.l.sby set"
	.license.l.text insert 1.0 $xprez(license)

	button .license.done -text "Dismiss" -command "destroy .license"
	scrollbar .license.l.sby -command ".license.l.text yview"
	label .license.title1 -justify center -foreground #F00 \
		-text "GNU General Public License"
	label .license.title2 -justify center -foreground #F00 \
		-text "Version 2, June 1991"
	pack .license.title1 .license.title2 -fill x -side top
	pack .license.done -side bottom
	pack .license.l -fill both -side top -expand true
	pack .license.l.sby -side left -fill y
	pack .license.l.text -side right -fill both -expand 1
}

# Enable a button named b if $var is true
proc enableButton {b var} {
	global enableButton_v

	set enableButton_v(var) $var
	set enableButton_v(b) $b
	uplevel #0 {

		set foo [eval set bar $$enableButton_v(var)]
		if {$foo} {
			$enableButton_v(b) configure -state normal
		}
	}
}

# This will allow the user to set most of the various configurable
# options...
# namemap	- The AIs we have available
# xprez		- Global configuration data
# mustrestart	- true == mustrestart... :)
proc options {} {
	global namemap xprez staticfoo mustrestart

	# The below doesn't seem to do what I want...  ie. eval to false
	# when .options exists...
	#if {![catch focus .options]} {}

	if {$staticfoo == 1} { return }
	set staticfoo 1

	toplevel .options
	wm iconname .options {Options}
	wm title .options {Configurable X-TVP Options!}

	focus .options

	frame .options.bt
	button .options.bt.dismiss \
		-text {Dismiss} \
		-command {restart .c; destroy .options; set staticfoo 0}
	button .options.bt.apply \
		-text {Apply} \
		-state disabled \
		-command { \
			.options.bt.apply configure -state disabled; \
			restart .c; \
			xp_call mustrestart "enableButton .options.bt.apply mustrestart"}
	pack .options.bt -side bottom
	pack .options.bt.dismiss .options.bt.apply -side left
	xp_call mustrestart "enableButton .options.bt.apply mustrestart"

	scale .options.scale \
		-digits 0 \
		-from 1 \
		-label "Delay between AI turns" \
		-length 8c \
		-showvalue true \
		-to 500 \
		-variable xprez(aidelay) \
		-orient horiz
	pack .options.scale -side top -fill x -expand yes -padx .5c

	checkbutton .options.cclick \
		-variable xprez(roundclick) \
		-text "Click on canvas between rounds"

	pack .options.cclick -side top

	frame .options.ais
	frame .options.ais.ai1

	pack .options.ais -side left -pady 1c
	pack .options.ais.ai1 -side top

	foreach n {2 3 4} {
		set ai xprez(AI$n)
		set frame .options.ais.ai$n
		frame $frame
		pack $frame -side top

		label .options.ais.ai$n.name -text "Player #$n: "
		pack .options.ais.ai$n.name -side left

		foreach {psn} [array names namemap] {
			label $frame.l$psn \
				-text $psn
			radiobutton $frame.r$psn \
				-value $psn \
				-variable $ai
			pack $frame.l$psn $frame.r$psn -side left
		}
	}
}

# This should always be called from the main stuff.  It will setup hooks
# so that everytime a variable is changed which forces the game to be
# started-over, it warns the user...
proc varwatch {} {
	global xprez

	set i 0
	# set-up a process to watch each of the following vars
	foreach var {xprez(AI2) xprez(AI3) xprez(AI4)} {
		set i [incr i]
		xp_call $var "varcatch $var [eval set foo $$var]"
	}
}

# This is called via varwatch.  If $var is going to change, it asks
# if the user really wants to change $var.
proc varcatch {var old} {
	global xprez mustrestart novarcatch

	set new [eval set foo $$var];

	if {$novarcatch} {
		xp_call $var "varcatch $var $new"
		return
	}

	if {[string compare $new $old] == 0 || $mustrestart} {
		xp_call $var "varcatch $var $new"
		return;
	}

	set r [tk_dialog .warning {Need to restart!} \
		"You are about to make a change which requires restarting!  Do you wish to make the change, or keep the old value?  ($old, $var, $new)" \
		warning 0 "Accept" "Revert"]
	if {$r != 0} {
		# We have to do this outside of this proc because trapping
		# of variable writes to $var are disabled while we are in
		# here...
		after 1 "uplevel #0 \" set novarcatch 1; set $var $old; \
			set novarcatch 0; \""
#		set $var $old
		set new $old
	} else {
		set old $new
		if {$mustrestart == 0} {
			set mustrestart 1
		}
	}

	xp_call $var "varcatch $var $new"
}

# This does all of the stuff that is necessary to Restart a game
# c		- The canvas
# lnam		- The ids of the AIs on the canvas
# xprez		- Global configuration data
# mustrestart	- Flag denoting wether or not its time to restart the game
# namemap	- Converts AI names into AI types
proc restart {c} {
	global lnam xprez mustrestart namemap

  if {$mustrestart} {

	set mustrestart 0

	xp_configure $namemap($xprez(AI2)) $namemap($xprez(AI3)) \
		$namemap($xprez(AI4))

	$c itemconfigure $lnam(2) -text $xprez(AI2)
	$c itemconfigure $lnam(3) -text $xprez(AI3)
	$c itemconfigure $lnam(4) -text $xprez(AI4)

	deal $c
  }
}

# Call this before calling any *Cards routines...
# Creates images c1, c2, ... d1, d2 ... back, blank
# globals
#         xprez  --  global configuration data
proc LoadCards {} {
	global xprez

	# find our little card directory
	foreach carddir "[array names xprez carddir*] nodir" {
		if "![catch {image create photo c14 \
		   -file $xprez($carddir)/joker.gif}]" {
			break
		}
	}
	if "![string compare $carddir nodir]" {
		puts {Couldn't open card directory!}
		exit 1
	}

	image create photo c14 -file $xprez($carddir)/joker.gif
	image create photo s14 -file $xprez($carddir)/joker.gif
	image create photo h14 -file $xprez($carddir)/joker.gif
	image create photo d14 -file $xprez($carddir)/joker.gif
	image create photo back -file $xprez($carddir)/backs-$xprez(back).gif
	image create photo blank
	blank blank

	# Create the clubs!
	for {set i 1} {$i <= 13} {incr i} {
		image create photo c$i \
			-file $xprez($carddir)/clubs-${i}.gif
	}
	# Create the spades!
	for {set i 1} {$i <= 13} {incr i} {
		image create photo s$i \
			-file $xprez($carddir)/spades-${i}.gif
	}
	# Create the hearts!
	for {set i 1} {$i <= 13} {incr i} {
		image create photo h$i \
			-file $xprez($carddir)/hearts-${i}.gif
	}
	# Create the diamonds!
	for {set i 1} {$i <= 13} {incr i} {
		image create photo d$i \
			-file $xprez($carddir)/diamonds-${i}.gif
	}
}

# Call this once before calling ShowCards
# c		- The canvas
# xprez		- Global configuration data
# lh		- Left Hand ids
# th		- Top Hand ids
# bh		- Bottom Hand ids
# rh		- Right Hand ids
# mh		- Middle Thingy ids
proc InitCards { c } {
	global xprez lh th bh rh mh

	set yy $xprez(midy)
	for {set j 0} {$j < 4} {incr j} {
		set xx $xprez(midx)
		set mh(label$j) [$c create text \
			[expr $xx - $xprez(midlabdist)]c ${yy}c \
			-justify center \
			-anchor ne \
			-text ""]
		for {set i 0} {$i < 4} {incr i} {
			# Heh.  Watch-out.  This isn't a multi-dimension array.
			set mh($j,$i) [$c create image ${xx}c ${yy}c \
				-anchor nw \
				-image blank]
			set xx [expr $xx + $xprez(inc)]
		}
		set yy [expr $yy + $xprez(inc)]
	}

	set xx $xprez(topx)
	for {set i 0} {$i < 14} {incr i} {
		set th($i) [$c create image ${xx}c $xprez(topy)c \
			-image blank]
		set xx [expr $xx + $xprez(inc)]
	}

	# This is the human's hand.  We'll enable the button-clicking
	# doo-hickey on them.
	set xx $xprez(bottomx)
	for {set i 0} {$i < 14} {incr i} {
		set bh($i) [$c create image ${xx}c $xprez(bottomy)c \
			-image blank]
		# Disable the Double-click, for now...
		#$c bind $bh($i) <Double-Button-1> "LaySet $i $c"
		$c bind $bh($i) <Button-3> "LaySet $i $c"
		$c bind $bh($i) <Button-1> "SelectSet $i $c"
		$c bind $bh($i) <Button-2> "AutoLay $i $c"
		set xx [expr $xx + $xprez(inc)]
	}

	set yy $xprez(lefty)
	for {set i 0} {$i < 14} {incr i} {
		set lh($i) [$c create image $xprez(leftx)c ${yy}c \
			-image blank]
		set yy [expr $yy + $xprez(inc)]
	}

	set yy $xprez(righty)
	for {set i 0} {$i < 14} {incr i} {
		set rh($i) [$c create image $xprez(rightx)c ${yy}c \
			-image blank]
		set yy [expr $yy + $xprez(inc)]
	}
}

# Draw the cards on the table
# c				- The canvas
# top, bottom, left, right	- The hands ("d2 c11 s1 ...")
proc ShowCards { c top bottom left right } {
	global xprez th lh rh bh mh

	set i 0;  # counter of cards shown
	foreach card $top {
		$c itemconfigure $th($i) \
			-image $card
		set i [expr $i + 1]
	}

	set i 0;  # counter of # cards shown
	foreach card $bottom {
		$c itemconfigure $bh($i) \
			-image $card
		set i [expr $i + 1]
	}

	set i 0;  # number of cards shown
	foreach card $left {
		$c itemconfigure $lh($i) \
			-imag $card
		set i [expr $i + 1]
	}

	set i 0;  # number of cards shown
	foreach card $right {
		$c itemconfigure $rh($i) \
			-image $card
		set i [expr $i + 1]
	}

	# j refers to the playnums...
	for {set j 0} {$j < 4} {incr j} {
		for {set i 0} {$i < 4} {incr i} {
			if {$i < [xp_laid $j num]} {
				$c itemconfigure $mh($j,$i) \
					-image [xp_laid $j card]
				$c itemconfigure $mh(label$j) \
					-text $xprez(AI[xp_laid $j player])
			} else {
				$c itemconfigure $mh($j,$i) \
					-image blank
				$c itemconfigure $mh(label$j) \
					-text $xprez(AI[xp_laid $j player])
			}
		}
	}
}

# Save
# xprez		- Global configuration data
proc save {} {
	global xprez

	if "![xp_havefile]" {
		tk_dialog .junk {Upgrade Time!} {You must upgrade to tk42 or better and recompile in order to use the save functions!  Sorry!} error 0 "Dismiss"
		return
	}

	set file [tk_getSaveFile \
		-filetypes {{"X-Prez files" {.xtvp} } {"All files" * }} \
		-initialfile Untitled -defaultextension .xtvp]

	if "![string length $file]" return

	xp_save $file $xprez(AI2) $xprez(AI3) $xprez(AI4)
}

# Load
# lnam		- Some label ids
# xprez		- Global configuration data
# novarcatch	- Prevent changes to xprez(AI?) from being trapped by 
#                 traps set-up by our Options menu
# pos		- ids for the position labels
proc load {} {
	global lnam xprez novarcatch pos

	if "![xp_havefile]" {
		tk_dialog .junk {Upgrade Time!} {You must upgrade to tk42 or better and recompile in order to use the load function!  Sorry!} error 0 "Dismiss"
		return
	}

	set file [tk_getOpenFile \
		-filetypes {{"X-Prez files" {.xtvp} } {"All files" * }} \
		-defaultextension .xtvp]

	if "![string length $file]" return

	set z [xp_load $file $xprez(AI2) $xprez(AI3) $xprez(AI4)]

	set novarcatch 1
	set xprez(AI2) [lindex $z 0]
	set xprez(AI3) [lindex $z 1]
	set xprez(AI4) [lindex $z 2]
	set novarcatch 0

	.f.scores.a1 configure -text "$xprez(AI1) [xp_scores 1]"
	.f.scores.a2 configure -text "$xprez(AI2) [xp_scores 2]"
	.f.scores.a3 configure -text "$xprez(AI3) [xp_scores 3]"
	.f.scores.a4 configure -text "$xprez(AI4) [xp_scores 4]"

	.c itemconfigure $pos(2) -text [xp_position 2]
	.c itemconfigure $pos(3) -text [xp_position 3]
	.c itemconfigure $pos(4) -text [xp_position 4]

	ShowCards .c [xp_cards 4] [xp_cards 1] [xp_cards 2] [xp_cards 3]

	.c itemconfigure $lnam(2) -text $xprez(AI2)
	.c itemconfigure $lnam(3) -text $xprez(AI3)
	.c itemconfigure $lnam(4) -text $xprez(AI4)

	ai_resched_loop .c
	unselectcurrentset .c

# ALSO need to adjust the .f.pass button...

}

# This will deal...
# c		- The canvas
# xprez		- Global configuration data
# pos		- ids for the position labels
proc deal {c} {
	global xprez pos aimove_v

	set xxx [xp_deal]
	if {[string length $xxx] != 0} {
		tk_dialog .junk {Cards Switched} $xxx info 0 "Dismiss"
	}

	.f.scores.a1 configure -text "$xprez(AI1) [xp_scores 1]"
	.f.scores.a2 configure -text "$xprez(AI2) [xp_scores 2]"
	.f.scores.a3 configure -text "$xprez(AI3) [xp_scores 3]"
	.f.scores.a4 configure -text "$xprez(AI4) [xp_scores 4]"

	$c itemconfigure $pos(2) -text [xp_position 2]
	$c itemconfigure $pos(3) -text [xp_position 3]
	$c itemconfigure $pos(4) -text [xp_position 4]

	ShowCards $c [xp_cards 4] [xp_cards 1] [xp_cards 2] [xp_cards 3]

	.f.pass flash
	.f.pass configure \
		-text "Pass" \
		-command "pass $c"

	unselectcurrentset $c
	ai_resched_loop $c
}

# This is called as an event-handler by the Tcl after command.
# It can be called at anytime and will not assume that it is one
# of the AI players' turns.
# c		- The canvas
# xprez		- Global configuration data
# aimove_v	- Variables used by aimove
# cset		- Information about the currently-selected set
proc aimove {c} {
	global xprez aimove_v cset

	# prevent some event-processor from starting another after aimove
	# while we are in tkwait...
	set aimove_v(ailoop) {running}

	# If everyone's gone, and if we've been instructed to wait
	# for a mouse-click after every round, then we'll wait for
	# said mouse-click...  Also, don't enter into this wait-mode
	# if there is only one player left...  Also, don't enter this
	# if I just moved...  Also don't enter this if the human's out...
	# Or don't enter this if it is the human's turn...
	if {[xp_all] && $xprez(roundclick) && [xp_left] > 1 && !$aimove_v(jm) \
	  && [xp_human] && [xp_turn] != 1} {

		set aimove_v(waiting_for_click) true
		.status configure -text {Click on centre-screen!}
		bind $c <Button-1> {+set aimove_v(waiting_for_click) false}
		vwait aimove_v(waiting_for_click)
		.status configure -text {}

		set aimove_v(i) 0
		after $xprez(aidelay) {set aimove_v(i) 1}
		vwait aimove_v(i)
	}

	if {[string length [xp_aimove]]} {
		unselectcurrentset $c
		set aimove_v(jm) 0
	}

	# if it is the human's turn and if there is no currently-selected set
	if {[xp_turn] == 1 && ![string length $cset(current)]} {
		set cset(mystatus) $cset(stat1)
		.status configure -text $cset(mystatus)
	} else {
		if {![string compare [.status cget -text] $cset(stat1)]} {
			.status configure -text {}
		}
	}

	ShowCards $c [xp_cards 4] [xp_cards 1] [xp_cards 2] [xp_cards 3]

	# If it's time to deal, then change the "pass" puppy to a
	# "deal" puppy, eh...
	if {![xp_turn]} {
		.f.pass configure \
			-text "Deal!!" \
			-command "deal $c"
		FlashDeal .f.pass
	}

	if {[xp_turn] != 1 && [xp_turn] != 0} {
		set aimove_v(ailoop) [after $xprez(aidelay) aimove $c]
	} else {
		set aimove_v(ailoop) {}
	}
}

# This will flash a button, and continue flashing said button until
# xp_turn returns non-zero
# b		- A button to flash
proc FlashDeal {b} {
	if {[xp_turn] == 0} {
		$b flash
		after 150 FlashDeal $b
	}
}

# This will move the ailoop scheduling to an even divisor of $xprez(aidelay)
# c		- The canvas
# aimove_v	- aimove variables
# xprez		- Global configuration
proc ai_resched_loop {c} {
	global aimove_v xprez

	# Schedule an ailoop only if there isn't one already running
	if {[string compare $aimove_v(ailoop) "running"]} {
		if {[string length $aimove_v(ailoop)]} {
			after cancel $aimove_v(ailoop)
		}
		set aimove_v(ailoop) [after $xprez(aidelay) aimove $c]
	}
}

# Select a set based on the card clicked-on, or, if a set is already
# selected and is about to be selected, AGAIN, then lay that set.
# card		- Index to $bh() for which card was clicked on
# c		- The canvas
# xprez		- Global configuration data
# bh		- The cards on the bottom hand
# aimove_v	- aimove variables
# cset		- Information about the currently-selected set
proc SelectSet {card c} {
	global xprez bh aimove_v cset

	if {[string length $cset(current)] && \
	  [string compare $cset(current) [xp_select $card]] == 0} {
		# There is a currently-selected set, and it is the
		# same as the newly-selected set.

		set foo2 0
		foreach i $cset(current) {
			incr foo2
		}
		if {[string length [set foo [xp_lay $cset(current) $foo2]]]} {
			tk_dialog .loser {Can't lay set!} \
				$foo error 0 "Ok"
		} else {
			ai_resched_loop $c

			# denote the fact that the human just moved
			set aimove_v(jm) 1
		}

		unselectcurrentset $c

		ShowCards $c [xp_cards 4] [xp_cards 1] [xp_cards 2] [xp_cards 3]
		return
	}

	unselectcurrentset $c

	# xp_select will select the proper cards, and return 
	# what numbers the cards are, ie. it will return indice into
	# the $bh() array (note that it also takes an index into the
	# $bh() array).  If it can't make the clicked-card into
	# a current set, it will return an empty string.

	set cset(current) [xp_select $card]

	# Highlight the current-set...
	foreach i $cset(current) {
		$c move $bh($i) 0 -$xprez(raise)c
	}

	set cset(mystatus) $cset(stat2)
	.status configure -text $cset(mystatus)
}

# Unselect any possibly selected set
# c		- The canvas
# bh		- The bottom-hand cards
# xprez		- Global configuration data
# cset		- Information related to the currently-selected set
proc unselectcurrentset {c} {
	global bh xprez cset

	# if there is a currently-selected set, de-select it...
	if {[string length $cset(current)]} {
		foreach i $cset(current) {
			$c move $bh($i) 0 $xprez(raise)c
		}
	}
	set cset(current) {}

	# If we own the current status-line...
	if {![string compare [.status cget -text] $cset(mystatus)]} {
		if {[xp_turn] == 1} {
			set cset(mystatus) $cset(stat1)
			.status configure -text $cset(mystatus)
		} else {
			.status configure -text {}
		}
	}
}

# Lay the selected set
# card		- index to $bh() for which card was clicked on
# c		- the canvas
# xprez		- Global configuaration data
proc LaySet {card c} {
	global xprez

	unselectcurrentset $c

	SelectSet $card $c
	SelectSet $card $c
}

# Make the move of passing
# c		- The canvas
# xprez		- Global configuration data
# bh		- Bottom hand ids
# aimove_v	- aimove variables
proc pass {c} {
	global xprez bh aimove_v

	unselectcurrentset $c

	if {[string length [set foo [xp_lay 0 0]]]} {
		tk_dialog .loser {Can't make move!} \
			$foo error 0 "Ok"
	} else {
		ai_resched_loop $c

		# denote the fact that the human just moved
		set aimove_v(jm) 1
	}
}

Customize 

wm title . "Tim Vanderhoek's X-President!"
wm resizable . 0 0
canvas .c \
	-closeenough 0 \
	-height [expr $xprez(bottomy) + 1.7]c \
	-width [expr $xprez(rightx) + 1.5]c
frame .f -relief sunken
frame .f.filler -height 2.5c
button .f.quit -text "Quit!" -command "destroy ."
button .f.license -text "See License" -command "license"
button .f.save -text "Save" -command "save"
button .f.load -text "Load" -command "load"
button .f.options -text "Options" -command "options"
button .f.about -text "About" -command "about"
button .f.pass -text "Pass" -command "pass .c"
button .f.standings -text "Standings" -command "standings"

frame .f.scores -relief raised -borderwidth 2m -height 4c
label .f.scores.a1 -text "$xprez(AI1) [xp_scores 1]"
label .f.scores.a2 -text "$xprez(AI2) [xp_scores 2]"
label .f.scores.a3 -text "$xprez(AI3) [xp_scores 3]"
label .f.scores.a4 -text "$xprez(AI4) [xp_scores 4]"

label .status

pack .status -side bottom
pack .f .c -side left -fill both
pack .f.scores -side bottom
pack .f.scores.a1 .f.scores.a2 .f.scores.a3 .f.scores.a4
pack .f.filler .f.options .f.save .f.load .f.about .f.license .f.quit .f.pass \
	-side top -fill x

# This will watch over all the variables that, when changed, force
# us to start over, again.
set novarcatch 0
set mustrestart 0
varwatch

# The global arrays rh, lh, bh, th hold the 14 ids, corresponding to
# the first, second, third, etc. card.  When a card is clicked on,
# if it is in the special-cased bh hand, it will first call 
# choosecard, which will select all the cards below it that are of
# the same type (eg. all fives), and colour their backgrounds yellow
# to show that they have been selected.  Then, the next time the card
# is clicked on and calls choosecard, choosecard will release that this
# is the second time this card is being clicked (it keeps a global
# variable denoting which card was last clicked on) and attempt to
# lay the cards.  If it can't, it will pop-up a warning dialog box.
# It will then switch temporarily into auto-pilot mode.  A button,
# "AI move" will become active, and if pressed, the AI will make its
# move.  Otherwise, the AI will move based on the expiration of a timer.

# Configure the libass and AI stuff...
# Do the defaults here.  If they change stuff through options, alert the
# user that they will lose this game that is already started.

set pos(2) [.c create text $xprez(leftx)c .4c \
	-anchor n \
	-text [xp_position 2] \
	-fill #A02]
set lnam(2) [.c create text $xprez(leftx)c 0 \
	-anchor n \
	-text $xprez(AI2)]; # left

set pos(4) [.c create text [expr $xprez(topx) + $xprez(inc) * 7]c .4c \
	-anchor n \
	-text [xp_position 4] \
	-fill #A02]
set lnam(4) [.c create text [expr $xprez(topx) + $xprez(inc) * 7]c 0 \
	-anchor n \
	-text $xprez(AI4)]; # top

set pos(3) [.c create text $xprez(rightx)c .4c \
	-anchor n \
	-text [xp_position 3] \
	-fill #A02]
set lnam(3) [.c create text $xprez(rightx)c 0 \
	-anchor n \
	-text $xprez(AI3)]; # right

LoadCards
InitCards .c

xp_configure $namemap($xprez(AI2)) $namemap($xprez(AI3)) $namemap($xprez(AI4))

# Initialization for ai_resched_loop
set aimove_v(ailoop) [after $xprez(aidelay) aimove .c]

# Initialization for proc options
set staticfoo 0

# So that any clicks on open canvas will unselect the current set
set underbelly [.c create rectangle 0 0 [.c cget -width] [.c cget -height] \
	-outline {}]
.c bind $underbelly <Button-1> "unselectcurrentset .c"
.c raise $underbelly $lnam(3)

deal .c
