/* libai/ai.h
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#ifndef __AI_H
#define __AI_H

#include <ass.h>

enum ai_level {
 	SIMPLE,
 	NOLAY,
 	RAND
};

typedef struct ai_s {
 	struct hand_s seen[4];  /* Cards seen from each player */
 	position_t ps[4];  /* Position of each player */
 	int cleft[4];  /* Cards left for each player */
 	int whoami;  /* Am I player 0, 1, 2, or 3? */
 	enum ai_level l;  /* What level of ai intelligence? */
 	int pgone;  /* How many players have gone during the current round?
 	             * Ranges (1-4), or 0 after dealing, and initting */
} * ai_t;

void ai_init (ai_t, int, enum ai_level);  /* init ai_t, as player int (1-4) */
void ai_watch (ai_t, set_t, int);
void ai_notify (ai_t, position_t, position_t, position_t, position_t);
set_t ai_move (ai_t, const hand_t, const set_t);

#endif  /* __AI_H */
