/* libai/ai_err.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include <stdarg.h>
#include <stdio.h>

/*
 * Prints an error message if the first arg is true.
 */
int
ai_err (
 	int c,
 	const char * m,
 	...
) {
 	va_list va;

 	if (c) {
 		va_start (va, m);
 		vfprintf (stderr, m, va);
 		fflush (stderr);
 		va_end (va);
 	}

 	return c;
}
