/* libai/ai_init.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */


#include "ai.h"

/*
For now we don't carry information over between games, and, in fact,
we need to be called after every dealing, but this will someday hopefully
change...
*/

/*
 * Initialize an AI instance.  Make sure that the ai_t you pass it
 * has already been alloc'd, ala myai_t=malloc(sizeof(*myai_t)).
 */
void
ai_init (
 	ai_t ai,
 	int whoami,  /* Am I player #1, #2, #3, or #4? */
 	enum ai_level level
) {
 	int i, ii;

 	for (i=0; i<4; i++) {
 		for (ii=0; ii<54; ii++) ai->seen[i].cards[ii] = NAC;

 		ai->ps[i] = ASS;
 		/* Can't really touch ai->cleft[] here... */
 	}

 	ai->l = level;
 	ai->whoami = whoami - 1;
 	ai->pgone = 0;
}
