/* libai/ai_m_rand.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */


#include "ai.h"
#include "../rand/rand.h"

/*
 * See comments for ai_move().
 *
 * This will make moves for AI's of type RAND.
 * 
 * Internal use only.
 */
set_t
ai_m_rand (
 	ai_t ai,
 	const hand_t hand,
 	const set_t set
) {
 	static struct set_s ret;
 	struct set_s pos[14];  /* Possible sets to lay */
 	int epos;  /* highest indice into pos[] */
 	int i, n;

 	/* Special case where we lay on NAC to avoid an unending loop where
 	 * we check to see how few cards are needed in this set */
 	if (set->card == NAC) {
 		int x;

/* I'm tempted to take our 2nd-lowest card instead of our lowest card, here.
 * This would meaning trying to ensure that we always have one really
 * high card (ie. a JOKER or a TWO) that we can lay to guarantee a chance
 * to lay this low card. */

 		for (i=0; hand->cards[i] == NAC; i++) ;
 		ret.card = hand->cards[i];
 		ret.num = 1;  /* nyuk-nyuk */

 		return &ret;
 	}

 	ret.card = set->card;
 	ret.num = set->num;
 	if (ret.card == JOKER) {
 		/* Don't even bother... */
 		ret.card = NAC;
 		ret.num = 1;
 		return &ret;
 	}
 	ret.card++;

 	for (epos=0; ret.card <= JOKER; ret.card++) {
 		n = 0;  /* May return is non-zero (== min num of cards) */
 		ret.num = set->num;
 check:
 		if (ass_set (hand, &ret) &&
 		  ass_setlt (set, &ret)) {
 			/* Okay, we can lay this set.  Hmm...  If it's
 			 * wild, we can lower the number of cards, and still
 			 * lay it... */
 			n = ret.num;  /* known acceptable num */
 			ret.num--;
 			goto check;
 		}
 		if (n) {
 			pos[epos].card = ret.card;
 			pos[epos].num = n;
 			epos++;
 		}
 	}

 	if (!epos) {
 		ret.card = NAC;
 		ret.num = 1;
 		return &ret;
 	}
 	epos--;  /* Keep this as the highest indice into pos[] */
 	ret = pos[myrand() % (epos + 1)]; /* Must move to static struct set_s */
 	return &ret;
}
