/* libai/ai_watch.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include "ai.h"
#include "ai_err.h"

/*
 * Call this function everytime that someone makes a move...
 */
void
ai_watch (
 	ai_t ai,    /* This ai */
 	set_t set,  /* What set is being laid */
 	int player  /* (1-4), who is laying the set */
) {
 	int i, x;  /* junk */

 	ai_err (ai->whoami == (player - 1), "libai: You're taking my move!\n");

 	if (set->card != NAC) ai->cleft[player-1] -= set->num;
 	ai_err (ai->cleft[player-1] < 0,
 	   "libai: ai_watch(): mover hasn't cards!\n");

 	/* Find the number of players who are supposed to go during this round.
 	 * NOTE that this will still work even if this guy is laying his last
 	 * card, since the card won't be removed 'till later in this func. */
 	for (x=i=0; i<4; i++) if (ai->cleft[i] == 0) x++;
 	if (ai->pgone >= 4-x) ai->pgone = 1; else ai->pgone++;
 	/* We use >= in the above, since the > case is possible where
 	 * the last mover in the round was ourself (see ai_move() -- we
 	 * just increment ai->pgone, we don't check for wrap-a-around. */

 	/* Take the cards from set, and move them into our list of seen
 	 * cards... */
 	/* Find the first empty slot in seen */
 	for (i=0; ai->seen[player-1].cards[i] != NAC; i++) ;
 	for (x=set->num; x; x--) ai->seen[player-1].cards[(i+x)-1] = set->card;
}
